/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers.contenttype;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public final class ContentType {
    private static final List<String> APPLICATION_TYPES_CONSIDERED_TO_BE_STRING = Arrays.asList("javascript", "ecmascript");
    private static final Pattern TEXT_PATTERN = Pattern.compile("^(text/.*)|(application/(vnd\\..+\\+)?(" + String.join((CharSequence)"|", APPLICATION_TYPES_CONSIDERED_TO_BE_STRING) + "))$");
    private static final Pattern JSON_PATTERN = Pattern.compile("(application/(vnd\\..+\\+)?json)");
    private static final String JSON_MERGE_PATCH = "application/merge-patch+json";
    public static final ContentType APPLICATION_JSON = ContentType.of("application/json");
    public static final ContentType APPLICATION_MERGE_PATCH_JSON = ContentType.of("application/merge-patch+json");
    private final String value;
    private final String mediaType;
    private final ParsingStrategy parsingStrategy;

    private ContentType(String value, String mediaType, ParsingStrategy parsingStrategy) {
        this.value = value;
        this.mediaType = mediaType;
        this.parsingStrategy = parsingStrategy;
    }

    public static ContentType of(CharSequence contentTypeValue) {
        String lowerCaseValue = ConditionChecker.checkNotNull(contentTypeValue, "contentTypeValue").toString().toLowerCase();
        String mediaType = lowerCaseValue.split(";")[0];
        ParsingStrategy parsingStrategy = JSON_MERGE_PATCH.equals(mediaType) ? ParsingStrategy.JSON_MERGE_PATCH : (TEXT_PATTERN.matcher(mediaType).matches() ? ParsingStrategy.TEXT : (JSON_PATTERN.matcher(mediaType).matches() ? ParsingStrategy.JSON : ParsingStrategy.BINARY));
        return new ContentType(lowerCaseValue, mediaType, parsingStrategy);
    }

    public ParsingStrategy getParsingStrategy() {
        return this.parsingStrategy;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDittoProtocol() {
        return "application/vnd.eclipse.ditto+json".equals(this.mediaType);
    }

    public boolean isText() {
        return this.parsingStrategy == ParsingStrategy.TEXT;
    }

    public boolean isJson() {
        return this.parsingStrategy == ParsingStrategy.JSON;
    }

    public boolean isJsonMergePatch() {
        return JSON_MERGE_PATCH.equals(this.mediaType);
    }

    public boolean isBinary() {
        return this.parsingStrategy == ParsingStrategy.BINARY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType that = (ContentType)o;
        return this.value.equals(that.value) && this.parsingStrategy == that.parsingStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.parsingStrategy});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [value=" + this.value + ", parsingStrategy=" + (Object)((Object)this.parsingStrategy) + "]";
    }

    public static enum ParsingStrategy {
        TEXT,
        JSON,
        JSON_MERGE_PATCH,
        BINARY;

    }
}

