/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers.entitytag;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoHeaderInvalidException;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagBuilder;

@Immutable
public final class EntityTag {
    private static final String VALIDATION_ERROR_MESSAGE_TEMPLATE = "The opaque tag <%s> is not a valid entity-tag.";
    private static final Pattern ENTITY_TAG_REGEX_PATTERN = Pattern.compile("(W/)?(\"[^\"*]*\")");
    private static final String WEAK_PREFIX = "W/";
    private final boolean weak;
    private final String opaqueTag;

    private EntityTag(boolean weak, String opaqueTag) {
        if (!EntityTag.isValid(opaqueTag)) {
            String errorMessage = String.format(VALIDATION_ERROR_MESSAGE_TEMPLATE, opaqueTag);
            throw (DittoHeaderInvalidException)DittoHeaderInvalidException.newCustomMessageBuilder(errorMessage).build();
        }
        this.weak = weak;
        this.opaqueTag = opaqueTag;
    }

    public static boolean isValid(@Nullable CharSequence entityTag) {
        boolean result = false;
        if (null != entityTag) {
            Matcher matcher = ENTITY_TAG_REGEX_PATTERN.matcher(entityTag);
            result = matcher.matches();
        }
        return result;
    }

    public String getOpaqueTag() {
        return this.opaqueTag;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public boolean strongCompareTo(EntityTag otherEntityTag) {
        if (this.isWeak()) {
            return false;
        }
        if (otherEntityTag.isWeak()) {
            return false;
        }
        return this.equals(otherEntityTag);
    }

    public boolean weakCompareTo(EntityTag otherEntityTag) {
        return Objects.equals(this.getOpaqueTag(), otherEntityTag.getOpaqueTag());
    }

    public static EntityTag fromString(String entityTag) {
        ConditionChecker.checkNotNull(entityTag);
        boolean weak = entityTag.startsWith(WEAK_PREFIX);
        if (weak) {
            return EntityTag.weak(entityTag.substring(2));
        }
        return EntityTag.strong(entityTag);
    }

    public static Optional<EntityTag> fromEntity(@Nullable Object entity) {
        return EntityTagBuilder.buildFromEntity(entity);
    }

    public static EntityTag strong(String opaqueTag) {
        return new EntityTag(false, opaqueTag);
    }

    public static EntityTag weak(String opaqueTag) {
        return new EntityTag(true, opaqueTag);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isWeak()) {
            stringBuilder.append(WEAK_PREFIX);
        }
        stringBuilder.append(this.getOpaqueTag());
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTag entityTag = (EntityTag)o;
        return this.weak == entityTag.weak && Objects.equals(this.opaqueTag, entityTag.opaqueTag);
    }

    public int hashCode() {
        return Objects.hash(this.weak, this.opaqueTag);
    }

    private static final class Regex {
        private static final String WEAK_PREFIX = "(W/)";
        private static final String OPAQUE_TAG = "(\"[^\"*]*\")";
        private static final String ENTITY_TAG = "(W/)?(\"[^\"*]*\")";

        private Regex() {
        }
    }
}

