/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers.entitytag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.entitytag.EntityTagMatcher;

@Immutable
public final class EntityTagMatchers
implements Iterable<EntityTagMatcher> {
    public static final Pattern ENTITY_TAG_MATCHERS_PATTERN = Pattern.compile("\\s*,\\s*");
    private final List<EntityTagMatcher> entityTagMatcherList;

    private EntityTagMatchers(List<EntityTagMatcher> entityTagMatcherList) {
        ConditionChecker.checkNotNull(entityTagMatcherList, "entityTagMatcherList");
        this.entityTagMatcherList = Collections.unmodifiableList(new ArrayList<EntityTagMatcher>(entityTagMatcherList));
    }

    public static EntityTagMatchers fromCommaSeparatedString(String commaSeparatedEntityTagString) {
        return EntityTagMatchers.fromStrings(ENTITY_TAG_MATCHERS_PATTERN.split(commaSeparatedEntityTagString));
    }

    public static EntityTagMatchers fromStrings(String ... entityTagMatcherStrings) {
        return EntityTagMatchers.fromList(Arrays.stream(entityTagMatcherStrings).map(EntityTagMatcher::fromString).collect(Collectors.toList()));
    }

    public static EntityTagMatchers fromList(List<EntityTagMatcher> entityTagMatchers) {
        return new EntityTagMatchers(entityTagMatchers);
    }

    public String toString() {
        return this.stream().map(EntityTagMatcher::toString).collect(Collectors.joining(","));
    }

    public boolean isEmpty() {
        return this.entityTagMatcherList.isEmpty();
    }

    public Stream<EntityTagMatcher> stream() {
        return this.entityTagMatcherList.stream();
    }

    @Override
    public Iterator<EntityTagMatcher> iterator() {
        return this.entityTagMatcherList.iterator();
    }

    @Override
    public void forEach(Consumer<? super EntityTagMatcher> action) {
        this.entityTagMatcherList.forEach(action);
    }

    @Override
    public Spliterator<EntityTagMatcher> spliterator() {
        return this.entityTagMatcherList.spliterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTagMatchers that = (EntityTagMatchers)o;
        return Objects.equals(this.entityTagMatcherList, that.entityTagMatcherList);
    }

    public int hashCode() {
        return Objects.hash(this.entityTagMatcherList);
    }
}

