/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers.metadata;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeader;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaderKey;

@Immutable
final class DefaultMetadataHeader
implements MetadataHeader {
    private final MetadataHeaderKey key;
    private final JsonValue value;

    private DefaultMetadataHeader(MetadataHeaderKey key, JsonValue value) {
        this.key = ConditionChecker.checkNotNull(key, "key");
        this.value = ConditionChecker.checkNotNull(value, "value");
    }

    static DefaultMetadataHeader of(MetadataHeaderKey key, JsonValue value) {
        return new DefaultMetadataHeader(key, value);
    }

    static DefaultMetadataHeader fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull(jsonObject, "jsonObject");
        return DefaultMetadataHeader.of(DefaultMetadataHeader.tryToGetMetadataHeaderKey(DefaultMetadataHeader.tryToGetValue(jsonObject, MetadataHeader.JsonFields.METADATA_KEY)), DefaultMetadataHeader.tryToGetMetadataHeaderValue(jsonObject));
    }

    private static <T> T tryToGetValue(JsonObject metadataEntry, JsonFieldDefinition<T> fieldDefinition) {
        return metadataEntry.getValue(fieldDefinition).orElseThrow(() -> {
            String msgPattern = "Metadata header entry JSON object did not include required <{0}> field!";
            return (JsonMissingFieldException)JsonMissingFieldException.newBuilder().message(MessageFormat.format("Metadata header entry JSON object did not include required <{0}> field!", fieldDefinition.getPointer())).build();
        });
    }

    private static MetadataHeaderKey tryToGetMetadataHeaderKey(String metadataHeaderKeyPath) {
        try {
            return DefaultMetadataHeader.getMetadataHeaderKey(metadataHeaderKeyPath);
        }
        catch (IllegalArgumentException e) {
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("The metadata header key <{0}> is invalid!", metadataHeaderKeyPath)).description(e.getMessage()).cause((Throwable)e).build();
        }
    }

    private static MetadataHeaderKey getMetadataHeaderKey(CharSequence metadataHeaderKeyPath) {
        return MetadataHeaderKey.of(JsonPointer.of((CharSequence)metadataHeaderKeyPath));
    }

    private static JsonValue tryToGetMetadataHeaderValue(JsonObject metadataEntry) {
        return DefaultMetadataHeader.tryToGetValue(metadataEntry, MetadataHeader.JsonFields.METADATA_VALUE);
    }

    @Override
    public MetadataHeaderKey getKey() {
        return this.key;
    }

    @Override
    public JsonValue getValue() {
        return this.value;
    }

    @Override
    public int compareTo(MetadataHeader metadataHeader) {
        int keyComparisonResult;
        ConditionChecker.checkNotNull(metadataHeader, "metadataHeader");
        int result = this.equals(metadataHeader) ? 0 : (0 == (keyComparisonResult = this.key.compareTo(metadataHeader.getKey())) ? this.compareValues(metadataHeader.getValue()) : keyComparisonResult);
        return result;
    }

    private int compareValues(JsonValue otherValue) {
        Comparator<JsonValue> jsonValueComparator = Comparator.comparing(v -> v.isString() ? v.asString() : v.toString());
        return Integer.compare(jsonValueComparator.compare(this.value, otherValue), 0);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMetadataHeader that = (DefaultMetadataHeader)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public JsonObject toJson() {
        return JsonObject.newBuilder().set(MetadataHeader.JsonFields.METADATA_KEY, (Object)this.key.toString()).set(MetadataHeader.JsonFields.METADATA_VALUE, (Object)this.value).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [key=" + this.key + ", value=" + this.value + "]";
    }
}

