/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.headers.metadata;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.metadata.MetadataHeaderKey;

@Immutable
final class DefaultMetadataHeaderKey
implements MetadataHeaderKey {
    static final JsonKey HIERARCHY_WILDCARD = JsonKey.of((CharSequence)"*");
    private final JsonPointer path;

    private DefaultMetadataHeaderKey(JsonPointer path) {
        this.path = path;
    }

    public static DefaultMetadataHeaderKey parse(CharSequence key) {
        return DefaultMetadataHeaderKey.of(JsonPointer.of((CharSequence)ConditionChecker.argumentNotEmpty(key, "key")));
    }

    public static DefaultMetadataHeaderKey of(JsonPointer path) {
        DefaultMetadataHeaderKey result = new DefaultMetadataHeaderKey(ConditionChecker.checkNotNull(path, "path"));
        result.validate();
        return result;
    }

    private void validate() {
        if (this.path.isEmpty()) {
            throw new IllegalArgumentException("The path of a metadata header key must not be empty!");
        }
        if (this.appliesToAllLeaves() && 2 != this.path.getLevelCount()) {
            throw new IllegalArgumentException(MessageFormat.format("A wildcard path of a metadata header key must have exactly two levels but it had <{0}>!", this.path.getLevelCount()));
        }
        AtomicInteger levelCounter = new AtomicInteger(0);
        this.path.forEach(jsonKey -> {
            int currentLvl = levelCounter.getAndIncrement();
            if (0 < currentLvl && jsonKey.equals(HIERARCHY_WILDCARD)) {
                throw new IllegalArgumentException(MessageFormat.format("The path of a metadata header key must not contain <{0}> at level <{1}>!", HIERARCHY_WILDCARD, currentLvl));
            }
        });
    }

    @Override
    public boolean appliesToAllLeaves() {
        return this.path.getRoot().filter(HIERARCHY_WILDCARD::equals).isPresent();
    }

    @Override
    public JsonPointer getPath() {
        JsonPointer result = this.appliesToAllLeaves() ? (JsonPointer)this.path.getSubPointer(1).orElseThrow(NoSuchElementException::new) : this.path;
        return result;
    }

    @Override
    public int compareTo(MetadataHeaderKey other) {
        ConditionChecker.checkNotNull(other, "other");
        int result = this.equals(other) ? 0 : (this.appliesToAllLeaves() ? (other.appliesToAllLeaves() ? this.comparePaths(other.getPath()) : -1) : (!other.appliesToAllLeaves() ? this.comparePaths(other.getPath()) : 1));
        return result;
    }

    private int comparePaths(JsonPointer otherPath) {
        Comparator<JsonPointer> jsonPointerComparator = Comparator.comparing(JsonPointer::toString);
        return Integer.compare(jsonPointerComparator.compare(this.path, otherPath), 0);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMetadataHeaderKey that = (DefaultMetadataHeaderKey)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    @Override
    public String toString() {
        return this.path.toString();
    }
}

