/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.json;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldMarker;

public enum FieldType implements JsonFieldMarker,
Predicate<JsonField>
{
    REGULAR,
    SPECIAL,
    HIDDEN;

    private final Predicate<JsonField> predicate = jsonField -> {
        Optional definition = jsonField.getDefinition();
        return !definition.isPresent() || jsonField.isMarkedAs((JsonFieldMarker)this, new JsonFieldMarker[0]);
    };

    public static Predicate<JsonField> notHidden() {
        return HIDDEN.negate();
    }

    public static Predicate<JsonField> regularOrSpecial() {
        return REGULAR.or(SPECIAL);
    }

    public static Predicate<JsonField> all() {
        return unused -> true;
    }

    @Override
    public boolean test(JsonField jsonField) {
        return this.predicate.test(jsonField);
    }
}

