/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.base.json;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;

public interface Jsonifiable<J extends JsonValue> {
    default public JsonSchemaVersion getLatestSchemaVersion() {
        return Arrays.stream(this.getSupportedSchemaVersions()).max(Comparator.naturalOrder()).orElseThrow(() -> new IllegalStateException("Jsonifiable does not provide information about which schema versions it implements"));
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_1, JsonSchemaVersion.V_2};
    }

    default public JsonSchemaVersion getImplementedSchemaVersion() {
        return this.getLatestSchemaVersion();
    }

    default public boolean implementsSchemaVersion(int version) {
        return JsonSchemaVersion.forInt(version).map(this::implementsSchemaVersion).orElse(false);
    }

    default public boolean implementsSchemaVersion(JsonSchemaVersion schemaVersion) {
        return Arrays.asList(this.getSupportedSchemaVersions()).contains(schemaVersion);
    }

    public J toJson();

    default public String toJsonString() {
        return this.toJson().toString();
    }

    public static interface WithFieldSelectorAndPredicate<T>
    extends WithPredicate<JsonObject, T>,
    WithFieldSelector {
        default public JsonObject toJson(JsonFieldSelector fieldSelector, Predicate<T> predicate) {
            return ((JsonObject)this.toJson(this.getLatestSchemaVersion(), predicate)).get(fieldSelector);
        }

        default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector, Predicate<T> predicate) {
            return ((JsonObject)this.toJson(schemaVersion, predicate)).get(fieldSelector);
        }

        default public String toJsonString(JsonFieldSelector fieldSelector, Predicate<T> predicate) {
            return this.toJsonString(this.getLatestSchemaVersion(), fieldSelector, predicate);
        }

        default public String toJsonString(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector, Predicate<T> predicate) {
            return this.toJson(schemaVersion, fieldSelector, predicate).toString();
        }
    }

    public static interface WithFieldSelector
    extends Jsonifiable<JsonObject>,
    WithPointer<JsonObject> {
        default public JsonObject toJson(JsonFieldSelector fieldSelector) {
            return this.toJson(this.getLatestSchemaVersion(), fieldSelector);
        }

        public JsonObject toJson(JsonSchemaVersion var1, JsonFieldSelector var2);

        default public String toJsonString(JsonFieldSelector fieldSelector) {
            return this.toJson(fieldSelector).toString();
        }

        default public String toJsonString(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
            return this.toJson(schemaVersion, fieldSelector).toString();
        }

        @Override
        default public JsonObject toJson(JsonPointer pointer) {
            return this.toJson(pointer.toFieldSelector());
        }

        @Override
        default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonPointer pointer) {
            return this.toJson(schemaVersion, pointer.toFieldSelector());
        }
    }

    public static interface WithPointer<J extends JsonValue>
    extends Jsonifiable<J> {
        default public J toJson(JsonPointer pointer) {
            return this.toJson(this.getLatestSchemaVersion(), pointer);
        }

        public J toJson(JsonSchemaVersion var1, JsonPointer var2);

        default public String toJsonString(JsonPointer pointer) {
            return this.toJson(pointer).toString();
        }

        default public String toJsonString(JsonSchemaVersion schemaVersion, JsonPointer pointer) {
            return this.toJson(schemaVersion, pointer).toString();
        }
    }

    public static interface WithPredicate<J extends JsonValue, T>
    extends Jsonifiable<J> {
        default public J toJson(Predicate<T> predicate) {
            if (predicate instanceof JsonSchemaVersion) {
                return this.toJson((JsonSchemaVersion)predicate, FieldType.notHidden());
            }
            return this.toJson(this.getLatestSchemaVersion(), predicate);
        }

        public J toJson(JsonSchemaVersion var1, Predicate<T> var2);

        default public String toJsonString(Predicate<T> predicate) {
            return this.toJson(predicate).toString();
        }

        default public String toJsonString(JsonSchemaVersion schemaVersion, Predicate<T> predicate) {
            return this.toJson(schemaVersion, predicate).toString();
        }
    }
}

