/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.enforcers.DefaultEffectedSubjects;
import org.eclipse.ditto.model.enforcers.EffectedSubjectIds;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;
import org.eclipse.ditto.model.enforcers.Enforcer;
import org.eclipse.ditto.model.enforcers.ImmutableEffectedSubjectIds;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
public final class AclEnforcer
implements Enforcer {
    private static final Set<String> THING_PERMISSION_NAMES = Arrays.stream(Permission.values()).map(Enum::name).collect(Collectors.toSet());
    private final AccessControlList acl;

    private AclEnforcer(AccessControlList acl) {
        this.acl = acl;
    }

    public static AclEnforcer of(AccessControlList acl) {
        return new AclEnforcer(acl);
    }

    @Override
    public boolean hasUnrestrictedPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, Permissions permissions) {
        org.eclipse.ditto.model.things.Permissions mappedPermissions = AclEnforcer.mapPermissions(permissions);
        if (mappedPermissions.isEmpty()) {
            return false;
        }
        Set grantedSubjects = this.acl.getAuthorizedSubjectsFor(mappedPermissions);
        return authorizationContext.getAuthorizationSubjects().stream().anyMatch(grantedSubjects::contains);
    }

    @Override
    public boolean hasPartialPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, Permissions permissions) {
        return this.hasUnrestrictedPermissions(resourceKey, authorizationContext, permissions);
    }

    @Override
    public JsonObject buildJsonView(ResourceKey resourceKey, Iterable<JsonField> jsonFields, AuthorizationContext authorizationContext, Permissions permissions) {
        return this.hasUnrestrictedPermissions(resourceKey, authorizationContext, permissions) ? JsonFactory.newObjectBuilder(jsonFields).build() : JsonFactory.newObject();
    }

    @Override
    public EffectedSubjectIds getSubjectIdsWithPermission(ResourceKey resourceKey, Permissions permissions) {
        Set<String> grantedSubjects = this.getSubjectIdsWithPartialPermission(resourceKey, permissions);
        return ImmutableEffectedSubjectIds.ofGranted(grantedSubjects);
    }

    @Override
    public EffectedSubjects getSubjectsWithPermission(ResourceKey resourceKey, Permissions permissions) {
        Set<AuthorizationSubject> grantedSubjects = this.getSubjectsWithPartialPermission(resourceKey, permissions);
        return DefaultEffectedSubjects.of(grantedSubjects, Collections.emptySet());
    }

    @Override
    public Set<String> getSubjectIdsWithPartialPermission(ResourceKey resourceKey, Permissions permissions) {
        return this.acl.getAuthorizedSubjectsFor(AclEnforcer.mapPermissions(permissions)).stream().map(AuthorizationSubject::getId).collect(Collectors.toSet());
    }

    @Override
    public Set<AuthorizationSubject> getSubjectsWithPartialPermission(ResourceKey resourceKey, Permissions permissions) {
        return this.acl.getAuthorizedSubjectsFor(AclEnforcer.mapPermissions(permissions));
    }

    private static org.eclipse.ditto.model.things.Permissions mapPermissions(Permissions policyPermissions) {
        List permissionList = policyPermissions.stream().flatMap(name -> {
            if (THING_PERMISSION_NAMES.contains(name)) {
                return Stream.of(Permission.valueOf((String)name));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        return ThingsModelFactory.newPermissions(permissionList);
    }
}

