/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;

@Immutable
public final class DefaultEffectedSubjects
implements EffectedSubjects {
    private final Set<AuthorizationSubject> granted;
    private final Set<AuthorizationSubject> revoked;

    private DefaultEffectedSubjects(Set<AuthorizationSubject> granted, Set<AuthorizationSubject> revoked) {
        this.granted = granted;
        this.revoked = revoked;
    }

    public static DefaultEffectedSubjects of(Collection<AuthorizationSubject> granted, Collection<AuthorizationSubject> revoked) {
        return new DefaultEffectedSubjects(DefaultEffectedSubjects.makeUnmodifiable((Collection)ConditionChecker.checkNotNull(granted, (String)"granted")), DefaultEffectedSubjects.makeUnmodifiable((Collection)ConditionChecker.checkNotNull(revoked, (String)"revoked")));
    }

    private static Set<AuthorizationSubject> makeUnmodifiable(Collection<AuthorizationSubject> subjectIds) {
        return Collections.unmodifiableSet(new HashSet<AuthorizationSubject>(subjectIds));
    }

    @Override
    public Set<AuthorizationSubject> getGranted() {
        return this.granted;
    }

    @Override
    public Set<AuthorizationSubject> getRevoked() {
        return this.revoked;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEffectedSubjects that = (DefaultEffectedSubjects)o;
        return this.granted.equals(that.granted) && this.revoked.equals(that.revoked);
    }

    public int hashCode() {
        return Objects.hash(this.granted, this.revoked);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [granted=" + this.granted + ", revoked=" + this.revoked + "]";
    }
}

