/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers;

import java.util.Set;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.enforcers.EffectedSubjectIds;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.ResourceKey;

public interface Enforcer {
    default public boolean hasUnrestrictedPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, String permission, String ... furtherPermissions) {
        return this.hasUnrestrictedPermissions(resourceKey, authorizationContext, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    default public boolean hasUnrestrictedPermissions(Set<ResourceKey> resourceKeys, AuthorizationContext authorizationContext, String permission, String ... furtherPermissions) {
        return resourceKeys.stream().allMatch(resourceKey -> this.hasUnrestrictedPermissions((ResourceKey)resourceKey, authorizationContext, Permissions.newInstance((String)permission, (String[])furtherPermissions)));
    }

    public boolean hasUnrestrictedPermissions(ResourceKey var1, AuthorizationContext var2, Permissions var3);

    @Deprecated
    default public EffectedSubjectIds getSubjectIdsWithPermission(ResourceKey resourceKey, String permission, String ... furtherPermissions) {
        return this.getSubjectIdsWithPermission(resourceKey, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    default public EffectedSubjects getSubjectsWithPermission(ResourceKey resourceKey, String permission, String ... furtherPermissions) {
        return this.getSubjectsWithPermission(resourceKey, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    @Deprecated
    public EffectedSubjectIds getSubjectIdsWithPermission(ResourceKey var1, Permissions var2);

    public EffectedSubjects getSubjectsWithPermission(ResourceKey var1, Permissions var2);

    default public Set<String> getSubjectIdsWithPartialPermission(ResourceKey resourceKey, String permission, String ... furtherPermissions) {
        return this.getSubjectIdsWithPartialPermission(resourceKey, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    @Deprecated
    public Set<String> getSubjectIdsWithPartialPermission(ResourceKey var1, Permissions var2);

    public Set<AuthorizationSubject> getSubjectsWithPartialPermission(ResourceKey var1, Permissions var2);

    default public boolean hasPartialPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, String permission, String ... furtherPermissions) {
        return this.hasPartialPermissions(resourceKey, authorizationContext, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    public boolean hasPartialPermissions(ResourceKey var1, AuthorizationContext var2, Permissions var3);

    default public JsonObject buildJsonView(Iterable<JsonField> jsonFields, CharSequence resourceType, AuthorizationContext authorizationContext, String permission, String ... furtherPermissions) {
        return this.buildJsonView(ResourceKey.newInstance((CharSequence)resourceType, (CharSequence)JsonFactory.emptyPointer()), jsonFields, authorizationContext, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    default public JsonObject buildJsonView(ResourceKey resourceKey, Iterable<JsonField> jsonFields, AuthorizationContext authorizationContext, String permission, String ... furtherPermissions) {
        return this.buildJsonView(resourceKey, jsonFields, authorizationContext, Permissions.newInstance((String)permission, (String[])furtherPermissions));
    }

    default public JsonObject buildJsonView(ResourceKey resourceKey, Iterable<JsonField> jsonFields, AuthorizationContext authorizationContext, JsonFieldSelector allowlist, Permissions permissions) {
        JsonObject enforcedJsonView = this.buildJsonView(resourceKey, jsonFields, authorizationContext, permissions);
        ResourceKey rootResourceKey = ResourceKey.newInstance((CharSequence)resourceKey.getResourceType(), (CharSequence)JsonFactory.emptyPointer());
        boolean isAuthorizationSubjectRelevant = this.hasPartialPermissions(rootResourceKey, authorizationContext, permissions);
        if (isAuthorizationSubjectRelevant) {
            JsonObject inputJsonObject = JsonFactory.newObject(jsonFields);
            JsonObject allowedJsonView = inputJsonObject.get(allowlist);
            return JsonFactory.newObject((JsonObject)allowedJsonView, (JsonObject)enforcedJsonView);
        }
        return enforcedJsonView;
    }

    public JsonObject buildJsonView(ResourceKey var1, Iterable<JsonField> var2, AuthorizationContext var3, Permissions var4);
}

