/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.EffectedSubjectIds;

@Deprecated
@Immutable
public final class ImmutableEffectedSubjectIds
implements EffectedSubjectIds {
    private final Set<String> grantedSubjectIds;
    private final Set<String> revokedSubjectIds;

    private ImmutableEffectedSubjectIds(Collection<String> grantedSubjectIds, Collection<String> revokedSubjectIds) {
        this.grantedSubjectIds = ImmutableEffectedSubjectIds.makeUnmodifiable((Collection)ConditionChecker.checkNotNull(grantedSubjectIds, (String)"granted Subject IDs"));
        this.revokedSubjectIds = ImmutableEffectedSubjectIds.makeUnmodifiable((Collection)ConditionChecker.checkNotNull(revokedSubjectIds, (String)"revoked Subject IDs"));
    }

    private ImmutableEffectedSubjectIds(Builder builder) {
        this(builder.grantedSubjectIds, builder.revokedSubjectIds);
    }

    private static Set<String> makeUnmodifiable(Collection<String> subjectIds) {
        return Collections.unmodifiableSet(new HashSet<String>(subjectIds));
    }

    public static ImmutableEffectedSubjectIds of(Collection<String> grantedSubjectIds, Collection<String> revokedSubjectIds) {
        return new ImmutableEffectedSubjectIds(grantedSubjectIds, revokedSubjectIds);
    }

    public static ImmutableEffectedSubjectIds ofGranted(Collection<String> grantedSubjectIds) {
        return ImmutableEffectedSubjectIds.of(grantedSubjectIds, Collections.emptySet());
    }

    public static ImmutableEffectedSubjectIds ofRevoked(Collection<String> revokedSubjectIds) {
        return ImmutableEffectedSubjectIds.of(Collections.emptySet(), revokedSubjectIds);
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    @Override
    public Set<String> getGranted() {
        return this.grantedSubjectIds;
    }

    @Override
    public Set<String> getRevoked() {
        return this.revokedSubjectIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEffectedSubjectIds that = (ImmutableEffectedSubjectIds)o;
        return Objects.equals(this.grantedSubjectIds, that.grantedSubjectIds) && Objects.equals(this.revokedSubjectIds, that.revokedSubjectIds);
    }

    public int hashCode() {
        return Objects.hash(this.grantedSubjectIds, this.revokedSubjectIds);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [grantedSubjectIds=" + this.grantedSubjectIds + ", revokedSubjectIds=" + this.revokedSubjectIds + "]";
    }

    @NotThreadSafe
    public static final class Builder {
        private final Set<String> grantedSubjectIds = new HashSet<String>();
        private final Set<String> revokedSubjectIds = new HashSet<String>();

        private Builder() {
        }

        public Builder withGranted(CharSequence grantedSubjectId) {
            ConditionChecker.argumentNotEmpty((CharSequence)grantedSubjectId, (String)"subject ID with granted permissions");
            if (!this.revokedSubjectIds.contains(grantedSubjectId.toString())) {
                this.grantedSubjectIds.add(grantedSubjectId.toString());
            }
            return this;
        }

        public Builder withRevoked(CharSequence revokedSubjectId) {
            ConditionChecker.argumentNotEmpty((CharSequence)revokedSubjectId, (String)"subject ID with revoked permissions");
            this.revokedSubjectIds.add(revokedSubjectId.toString());
            this.grantedSubjectIds.remove(revokedSubjectId.toString());
            return this;
        }

        public ImmutableEffectedSubjectIds build() {
            return new ImmutableEffectedSubjectIds(this);
        }
    }
}

