/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.enforcers.Enforcer;
import org.eclipse.ditto.model.enforcers.tree.TreeBasedPolicyEnforcer;
import org.eclipse.ditto.model.enforcers.trie.TrieBasedPolicyEnforcer;
import org.eclipse.ditto.model.policies.Policy;

@Immutable
public final class PolicyEnforcers {
    private PolicyEnforcers() {
        throw new AssertionError();
    }

    public static Enforcer defaultEvaluator(Policy policy) {
        return PolicyEnforcers.throughputOptimizedEvaluator(policy);
    }

    public static Enforcer throughputOptimizedEvaluator(Policy policy) {
        return TrieBasedPolicyEnforcer.newInstance(policy);
    }

    public static Enforcer memoryOptimizedEvaluator(Policy policy) {
        return TreeBasedPolicyEnforcer.createInstance(policy);
    }
}

