/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.PointerLocation;
import org.eclipse.ditto.model.enforcers.tree.PointerLocationEvaluator;
import org.eclipse.ditto.model.enforcers.tree.PolicyTreeNode;
import org.eclipse.ditto.model.enforcers.tree.ResourceNode;
import org.eclipse.ditto.model.enforcers.tree.Visitor;
import org.eclipse.ditto.model.enforcers.tree.WeightedPermission;
import org.eclipse.ditto.model.enforcers.tree.WeightedPermissions;
import org.eclipse.ditto.model.policies.Permissions;

@ParametersAreNonnullByDefault
abstract class CheckPermissionsVisitor
implements Visitor<Boolean> {
    private final Collection<String> authSubjectIds;
    private final Permissions expectedPermissions;
    private final Function<JsonPointer, PointerLocation> pointerLocationEvaluator;
    private final WeightedPermissions weightedPermissions;
    private boolean collectPermissions;

    protected CheckPermissionsVisitor(JsonPointer resourcePointer, Collection<String> authSubjectIds, Permissions expectedPermissions) {
        this.authSubjectIds = ConditionChecker.argumentNotEmpty(authSubjectIds, (String)"authorization subject IDS");
        this.expectedPermissions = (Permissions)ConditionChecker.argumentNotEmpty((Collection)expectedPermissions, (String)"expected permissions");
        this.pointerLocationEvaluator = new PointerLocationEvaluator(resourcePointer);
        this.weightedPermissions = new WeightedPermissions();
        this.collectPermissions = false;
    }

    @Override
    public void visitTreeNode(PolicyTreeNode node) {
        if (PolicyTreeNode.Type.SUBJECT == node.getType()) {
            this.visitSubjectNode(node);
        } else {
            this.visitResourceNode((ResourceNode)node);
        }
    }

    private void visitSubjectNode(PolicyTreeNode subjectNode) {
        this.collectPermissions = this.authSubjectIds.contains(subjectNode.getName());
    }

    private void visitResourceNode(ResourceNode resourceNode) {
        if (this.collectPermissions) {
            this.aggregateWeightedPermissions(resourceNode, this.weightedPermissions);
        }
    }

    protected abstract void aggregateWeightedPermissions(ResourceNode var1, WeightedPermissions var2);

    protected final PointerLocation getLocationInRelationToTargetPointer(ResourceNode resourceNode) {
        return this.pointerLocationEvaluator.apply(resourceNode.getAbsolutePointer());
    }

    @Override
    public Boolean get() {
        return this.determineResult();
    }

    private boolean determineResult() {
        Map<String, WeightedPermission> granted = this.weightedPermissions.getGrantedWithHighestWeight((Collection<String>)this.expectedPermissions);
        return granted.size() == this.expectedPermissions.size() && !this.isAnyRevokedWithHigherWeight(granted);
    }

    private boolean isAnyRevokedWithHigherWeight(Map<String, WeightedPermission> granted) {
        Map<String, WeightedPermission> revoked = this.weightedPermissions.getRevokedWithHighestWeight((Collection<String>)this.expectedPermissions);
        for (String expectedPermission : this.expectedPermissions) {
            WeightedPermission revokedPermission;
            WeightedPermission grantedPermission = granted.get(expectedPermission);
            if (!CheckPermissionsVisitor.isRevokedWithHigherWeight(grantedPermission, revokedPermission = revoked.get(expectedPermission))) continue;
            return true;
        }
        return false;
    }

    private static boolean isRevokedWithHigherWeight(@Nullable WeightedPermission grantedPermission, @Nullable WeightedPermission revokedPermission) {
        boolean result = false;
        if (null != revokedPermission) {
            if (null != grantedPermission) {
                int revokedPermissionWeight = revokedPermission.getWeight();
                int grantedPermissionWeight = grantedPermission.getWeight();
                if (grantedPermissionWeight <= revokedPermissionWeight) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }
}

