/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.enforcers.tree.CheckPermissionsVisitor;
import org.eclipse.ditto.model.enforcers.tree.PointerLocation;
import org.eclipse.ditto.model.enforcers.tree.ResourceNode;
import org.eclipse.ditto.model.enforcers.tree.WeightedPermissions;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Permissions;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class CheckUnrestrictedPermissionsVisitor
extends CheckPermissionsVisitor {
    CheckUnrestrictedPermissionsVisitor(JsonPointer resourcePointer, Collection<String> authSubjectIds, Permissions expectedPermissions) {
        super(resourcePointer, authSubjectIds, expectedPermissions);
    }

    @Override
    protected void aggregateWeightedPermissions(ResourceNode resourceNode, WeightedPermissions weightedPermissions) {
        EffectedPermissions effectedPermissions = resourceNode.getPermissions();
        Permissions grantedPermissions = effectedPermissions.getGrantedPermissions();
        Permissions revokedPermissions = effectedPermissions.getRevokedPermissions();
        PointerLocation pointerLocation = this.getLocationInRelationToTargetPointer(resourceNode);
        if (PointerLocation.ABOVE == pointerLocation || PointerLocation.SAME == pointerLocation) {
            weightedPermissions.addGranted((Iterable<String>)grantedPermissions, resourceNode.getLevel());
            weightedPermissions.addRevoked((Iterable<String>)revokedPermissions, resourceNode.getLevel());
        } else if (PointerLocation.BELOW == pointerLocation) {
            weightedPermissions.addRevoked((Iterable<String>)revokedPermissions, resourceNode.getLevel());
        }
    }
}

