/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.enforcers.tree.PointerLocation;
import org.eclipse.ditto.model.enforcers.tree.PointerLocationEvaluator;
import org.eclipse.ditto.model.enforcers.tree.PolicyTreeNode;
import org.eclipse.ditto.model.enforcers.tree.ResourceNode;
import org.eclipse.ditto.model.enforcers.tree.Visitor;
import org.eclipse.ditto.model.enforcers.tree.WeightedPermission;
import org.eclipse.ditto.model.enforcers.tree.WeightedPermissions;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Permissions;

@Deprecated
@NotThreadSafe
final class CollectPartialGrantedSubjectIdsVisitor
implements Visitor<Set<String>> {
    private final Permissions expectedPermissions;
    private final Function<JsonPointer, PointerLocation> pointerLocationEvaluator;
    private final Set<String> grantedSubjects;
    private final Collection<ResourceNodeEvaluator> evaluators;
    @Nullable
    private ResourceNodeEvaluator currentEvaluator;

    CollectPartialGrantedSubjectIdsVisitor(JsonPointer resourcePointer, Permissions expectedPermissions) {
        this.expectedPermissions = expectedPermissions;
        this.pointerLocationEvaluator = new PointerLocationEvaluator(resourcePointer);
        this.grantedSubjects = new HashSet<String>();
        this.evaluators = new HashSet<ResourceNodeEvaluator>();
        this.currentEvaluator = null;
    }

    @Override
    public void visitTreeNode(PolicyTreeNode node) {
        if (PolicyTreeNode.Type.SUBJECT == node.getType()) {
            this.visitSubjectNode(node);
        } else {
            this.visitResourceNode((ResourceNode)node);
        }
    }

    private void visitSubjectNode(PolicyTreeNode subjectNode) {
        String currentSubjectId = subjectNode.getName();
        this.currentEvaluator = new ResourceNodeEvaluator(currentSubjectId);
        this.evaluators.add(this.currentEvaluator);
    }

    private void visitResourceNode(ResourceNode resourceNode) {
        if (null != this.currentEvaluator) {
            this.currentEvaluator.aggregateWeightedPermissions(resourceNode);
        }
    }

    @Override
    public Set<String> get() {
        this.evaluators.forEach(rec$ -> ((ResourceNodeEvaluator)rec$).evaluate());
        return new HashSet<String>(this.grantedSubjects);
    }

    @NotThreadSafe
    private final class ResourceNodeEvaluator {
        private final String subjectId;
        private final WeightedPermissions weightedPermissionsForSubjectId;

        private ResourceNodeEvaluator(String subjectId) {
            this.subjectId = subjectId;
            this.weightedPermissionsForSubjectId = new WeightedPermissions();
        }

        private void aggregateWeightedPermissions(ResourceNode resourceNode) {
            PointerLocation pointerLocation = this.getLocationInRelationToTargetPointer(resourceNode);
            EffectedPermissions effectedPermissions = resourceNode.getPermissions();
            Permissions grantedPermissions = effectedPermissions.getGrantedPermissions();
            if (PointerLocation.ABOVE == pointerLocation || PointerLocation.SAME == pointerLocation) {
                Permissions revokedPermissions = effectedPermissions.getRevokedPermissions();
                this.weightedPermissionsForSubjectId.addGranted((Iterable<String>)grantedPermissions, resourceNode.getLevel());
                this.weightedPermissionsForSubjectId.addRevoked((Iterable<String>)revokedPermissions, resourceNode.getLevel());
            } else if (PointerLocation.BELOW == pointerLocation) {
                this.weightedPermissionsForSubjectId.addGranted((Iterable<String>)grantedPermissions, resourceNode.getLevel());
            }
        }

        private PointerLocation getLocationInRelationToTargetPointer(ResourceNode resourceNode) {
            return (PointerLocation)((Object)CollectPartialGrantedSubjectIdsVisitor.this.pointerLocationEvaluator.apply(resourceNode.getAbsolutePointer()));
        }

        private void evaluate() {
            Map<String, WeightedPermission> granted;
            Map<String, WeightedPermission> revoked = this.weightedPermissionsForSubjectId.getRevokedWithHighestWeight((Collection<String>)CollectPartialGrantedSubjectIdsVisitor.this.expectedPermissions);
            if (this.areExpectedPermissionsEffectivelyRevoked(revoked, granted = this.weightedPermissionsForSubjectId.getGrantedWithHighestWeight((Collection<String>)CollectPartialGrantedSubjectIdsVisitor.this.expectedPermissions))) {
                CollectPartialGrantedSubjectIdsVisitor.this.grantedSubjects.remove(this.subjectId);
            } else if (this.areExpectedPermissionsEffectivelyGranted(granted, revoked)) {
                CollectPartialGrantedSubjectIdsVisitor.this.grantedSubjects.add(this.subjectId);
            }
        }

        private boolean areExpectedPermissionsEffectivelyRevoked(Map<String, WeightedPermission> revoked, Map<String, WeightedPermission> granted) {
            if (revoked.size() != CollectPartialGrantedSubjectIdsVisitor.this.expectedPermissions.size()) {
                return false;
            }
            for (String expectedPermission : CollectPartialGrantedSubjectIdsVisitor.this.expectedPermissions) {
                int revokedPermissionWeight;
                int grantedPermissionWeight;
                WeightedPermission revokedPermission = revoked.get(expectedPermission);
                WeightedPermission grantedPermission = granted.get(expectedPermission);
                if (null == grantedPermission || (grantedPermissionWeight = grantedPermission.getWeight()) <= (revokedPermissionWeight = revokedPermission.getWeight())) continue;
                return false;
            }
            return true;
        }

        private boolean areExpectedPermissionsEffectivelyGranted(Map<String, WeightedPermission> granted, Map<String, WeightedPermission> revoked) {
            if (granted.size() != CollectPartialGrantedSubjectIdsVisitor.this.expectedPermissions.size()) {
                return false;
            }
            for (String expectedPermission : CollectPartialGrantedSubjectIdsVisitor.this.expectedPermissions) {
                int grantedPermissionWeight;
                int revokedPermissionWeight;
                WeightedPermission grantedPermission = granted.get(expectedPermission);
                WeightedPermission revokedPermission = revoked.get(expectedPermission);
                if (null == revokedPermission || (revokedPermissionWeight = revokedPermission.getWeight()) < (grantedPermissionWeight = grantedPermission.getWeight())) continue;
                return false;
            }
            return true;
        }
    }
}

