/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.TreeBasedPolicyEnforcer;

@Immutable
final class EffectedResources {
    private final Set<TreeBasedPolicyEnforcer.PointerAndPermission> grantedResources;
    private final Set<TreeBasedPolicyEnforcer.PointerAndPermission> revokedResources;

    private EffectedResources(Set<TreeBasedPolicyEnforcer.PointerAndPermission> grantedResources, Set<TreeBasedPolicyEnforcer.PointerAndPermission> revokedResources) {
        this.grantedResources = Collections.unmodifiableSet(new HashSet<TreeBasedPolicyEnforcer.PointerAndPermission>(grantedResources));
        this.revokedResources = Collections.unmodifiableSet(new HashSet<TreeBasedPolicyEnforcer.PointerAndPermission>(revokedResources));
    }

    public static EffectedResources of(Set<TreeBasedPolicyEnforcer.PointerAndPermission> grantedResources, Set<TreeBasedPolicyEnforcer.PointerAndPermission> revokedResources) {
        ConditionChecker.checkNotNull(grantedResources, (String)"Granted Resources");
        ConditionChecker.checkNotNull(revokedResources, (String)"Revoked Resources");
        return new EffectedResources(grantedResources, revokedResources);
    }

    public Set<TreeBasedPolicyEnforcer.PointerAndPermission> getGrantedResources() {
        return this.grantedResources;
    }

    public Set<TreeBasedPolicyEnforcer.PointerAndPermission> getRevokedResources() {
        return this.revokedResources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectedResources that = (EffectedResources)o;
        return Objects.equals(this.grantedResources, that.grantedResources) && Objects.equals(this.revokedResources, that.revokedResources);
    }

    public int hashCode() {
        return Objects.hash(this.grantedResources, this.revokedResources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [grantedResources=" + this.grantedResources + ", revokedResources=" + this.revokedResources + ']';
    }
}

