/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.enforcers.DefaultEffectedSubjects;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;

@NotThreadSafe
final class EffectedSubjectsBuilder {
    private final Set<AuthorizationSubject> grantedSubjects = new HashSet<AuthorizationSubject>();
    private final Set<AuthorizationSubject> revokedSubjects = new HashSet<AuthorizationSubject>();

    EffectedSubjectsBuilder() {
    }

    public EffectedSubjectsBuilder withGranted(AuthorizationSubject grantedSubject) {
        if (!this.revokedSubjects.contains(grantedSubject)) {
            this.grantedSubjects.add(grantedSubject);
        }
        return this;
    }

    public EffectedSubjectsBuilder withRevoked(AuthorizationSubject revokedSubject) {
        this.revokedSubjects.add(revokedSubject);
        this.grantedSubjects.remove(revokedSubject);
        return this;
    }

    public EffectedSubjects build() {
        return DefaultEffectedSubjects.of(this.grantedSubjects, this.revokedSubjects);
    }
}

