/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.PointerLocation;

@Immutable
final class PointerLocationEvaluator
implements Function<JsonPointer, PointerLocation> {
    private final JsonPointer referencePointer;

    PointerLocationEvaluator(JsonPointer referencePointer) {
        this.referencePointer = (JsonPointer)ConditionChecker.checkNotNull((Object)referencePointer, (String)"reference pointer");
    }

    @Override
    public PointerLocation apply(JsonPointer evaluationPointer) {
        ConditionChecker.checkNotNull((Object)evaluationPointer, (String)"pointer to be evaluated");
        PointerLocation result = PointerLocation.DIFFERENT;
        if (this.isOnReferencePointer(evaluationPointer)) {
            int referencePointerLevelCount;
            int evaluationPointerLevelCount = evaluationPointer.getLevelCount();
            result = evaluationPointerLevelCount < (referencePointerLevelCount = this.referencePointer.getLevelCount()) ? PointerLocation.ABOVE : (evaluationPointerLevelCount > referencePointerLevelCount ? PointerLocation.BELOW : PointerLocation.SAME);
        }
        return result;
    }

    private boolean isOnReferencePointer(JsonPointer evaluationPointer) {
        boolean result = true;
        int referencePointerLevelCount = this.referencePointer.getLevelCount();
        int evaluationPointerLevelCount = evaluationPointer.getLevelCount();
        for (int currentLevel = 0; result && currentLevel < referencePointerLevelCount && currentLevel < evaluationPointerLevelCount; ++currentLevel) {
            JsonKey referencePointerCurrentLevelKey = this.referencePointer.get(currentLevel).orElse(null);
            result = evaluationPointer.get(currentLevel).filter(k -> k.equals(referencePointerCurrentLevelKey)).isPresent();
        }
        return result;
    }
}

