/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.Visitor;

interface PolicyTreeNode {
    public String getName();

    @Nonnull
    public Type getType();

    public Optional<PolicyTreeNode> getChild(String var1);

    default public PolicyTreeNode computeIfAbsent(String resourceName, Function<String, PolicyTreeNode> mappingFunction) {
        ConditionChecker.checkNotNull((Object)resourceName, (String)"resourceName");
        ConditionChecker.checkNotNull(mappingFunction, (String)"mappingFunction");
        Map<String, PolicyTreeNode> children = this.getChildren();
        return children.computeIfAbsent(resourceName, mappingFunction);
    }

    public Map<String, PolicyTreeNode> getChildren();

    public void addChild(PolicyTreeNode var1);

    public void accept(@Nonnull Visitor var1);

    public static enum Type {
        RESOURCE,
        SUBJECT;

    }
}

