/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.PolicyTreeNode;
import org.eclipse.ditto.model.enforcers.tree.Visitor;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Permissions;

@NotThreadSafe
final class ResourceNode
implements PolicyTreeNode {
    private final PolicyTreeNode parent;
    private final String name;
    private final Map<String, PolicyTreeNode> children;
    private EffectedPermissions permissions;
    private JsonPointer absolutePointer;

    private ResourceNode(PolicyTreeNode parent, String name, EffectedPermissions permissions) {
        this.parent = parent;
        this.name = name;
        this.children = new HashMap<String, PolicyTreeNode>();
        this.permissions = permissions;
        this.absolutePointer = null;
    }

    public static ResourceNode of(PolicyTreeNode parent, String name) {
        return ResourceNode.of(parent, name, EffectedPermissions.newInstance((Iterable)Permissions.none(), (Iterable)Permissions.none()));
    }

    public static ResourceNode of(PolicyTreeNode parent, String name, EffectedPermissions permissions) {
        ConditionChecker.checkNotNull((Object)parent, (String)"Parent");
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        ConditionChecker.checkNotNull((Object)permissions, (String)"Permissions");
        return new ResourceNode(parent, name, permissions);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public PolicyTreeNode.Type getType() {
        return PolicyTreeNode.Type.RESOURCE;
    }

    @Override
    public Optional<PolicyTreeNode> getChild(String resourceName) {
        return Optional.ofNullable(this.children.get(resourceName));
    }

    @Override
    public Map<String, PolicyTreeNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PolicyTreeNode childNode) {
        this.children.put(childNode.getName(), childNode);
    }

    @Override
    public void accept(@Nonnull Visitor visitor) {
        visitor.visitTreeNode(this);
        for (PolicyTreeNode child : this.children.values()) {
            child.accept(visitor);
        }
    }

    public Optional<PolicyTreeNode> getParent() {
        return Optional.of(this.parent);
    }

    public EffectedPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(EffectedPermissions permissions) {
        this.permissions = permissions;
    }

    public boolean isGranted(@Nonnull String possiblyGrantedPermission, String ... furtherPossiblyGrantedPermissions) {
        ConditionChecker.checkNotNull((Object)possiblyGrantedPermission, (String)"permission to be evaluated");
        ConditionChecker.checkNotNull((Object)furtherPossiblyGrantedPermissions, (String)"further permissions to be evaluated");
        HashSet<String> p = new HashSet<String>(1 + furtherPossiblyGrantedPermissions.length);
        p.add(possiblyGrantedPermission);
        Collections.addAll(p, furtherPossiblyGrantedPermissions);
        return this.areAllGranted(p);
    }

    public boolean areAllGranted(@Nonnull Collection<String> possiblyGrantedPermissions) {
        ResourceNode.checkPermissionsToBeEvaluated(possiblyGrantedPermissions);
        Permissions actuallyGrantedPermissions = this.permissions.getGrantedPermissions();
        Permissions actuallyRevokedPermissions = this.permissions.getRevokedPermissions();
        boolean areAllGranted = actuallyGrantedPermissions.containsAll(possiblyGrantedPermissions);
        boolean isNoneRevoked = Collections.disjoint(actuallyRevokedPermissions, possiblyGrantedPermissions);
        return areAllGranted && isNoneRevoked;
    }

    private static void checkPermissionsToBeEvaluated(Collection<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions to be evaluated");
    }

    public boolean areAllRevoked(@Nonnull Collection<String> possiblyRevokedPermissions) {
        ResourceNode.checkPermissionsToBeEvaluated(possiblyRevokedPermissions);
        Permissions actuallyRevokedPermissions = this.permissions.getRevokedPermissions();
        return actuallyRevokedPermissions.containsAll(possiblyRevokedPermissions);
    }

    @Nonnull
    public JsonPointer getAbsolutePointer() {
        JsonPointer result = this.absolutePointer;
        if (null != result) {
            return result;
        }
        this.absolutePointer = result = this.getAbsolutePointer(this);
        return result;
    }

    private JsonPointer getAbsolutePointer(ResourceNode resourceNode) {
        JsonPointer result = resourceNode.getParent().filter(p -> PolicyTreeNode.Type.RESOURCE == p.getType()).map(p -> (ResourceNode)p).map(this::getAbsolutePointer).orElseGet(JsonFactory::emptyPointer);
        return result.addLeaf(JsonFactory.newKey((CharSequence)resourceNode.getName()));
    }

    public int getLevel() {
        JsonPointer absolutePointer = this.getAbsolutePointer();
        return absolutePointer.getLevelCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceNode that = (ResourceNode)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.name, that.name) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.permissions, this.children);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + this.parent.getName() + ", name=" + this.name + ", permissions=" + this.permissions + ", children=" + this.children + ']';
    }
}

