/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.PolicyTreeNode;
import org.eclipse.ditto.model.enforcers.tree.Visitor;

final class SubjectNode
implements PolicyTreeNode {
    private final String name;
    private final Map<String, PolicyTreeNode> children = new HashMap<String, PolicyTreeNode>();

    private SubjectNode(String name) {
        this.name = name;
    }

    public static SubjectNode of(String name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return new SubjectNode(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public PolicyTreeNode.Type getType() {
        return PolicyTreeNode.Type.SUBJECT;
    }

    @Override
    public Optional<PolicyTreeNode> getChild(String resourceName) {
        return Optional.ofNullable(this.children.get(resourceName));
    }

    @Override
    public void addChild(PolicyTreeNode childNode) {
        this.children.put(childNode.getName(), childNode);
    }

    @Override
    public void accept(@Nonnull Visitor visitor) {
        visitor.visitTreeNode(this);
        for (PolicyTreeNode child : this.children.values()) {
            child.accept(visitor);
        }
    }

    @Override
    public Map<String, PolicyTreeNode> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectNode that = (SubjectNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.children);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", children=" + this.children + ']';
    }
}

