/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.EffectedSubjectIds;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;
import org.eclipse.ditto.model.enforcers.Enforcer;
import org.eclipse.ditto.model.enforcers.tree.CheckPartialPermissionsVisitor;
import org.eclipse.ditto.model.enforcers.tree.CheckUnrestrictedPermissionsVisitor;
import org.eclipse.ditto.model.enforcers.tree.CollectEffectedSubjectIdsVisitor;
import org.eclipse.ditto.model.enforcers.tree.CollectEffectedSubjectsVisitor;
import org.eclipse.ditto.model.enforcers.tree.CollectPartialGrantedSubjectIdsVisitor;
import org.eclipse.ditto.model.enforcers.tree.CollectPartialGrantedSubjectsVisitor;
import org.eclipse.ditto.model.enforcers.tree.EffectedResources;
import org.eclipse.ditto.model.enforcers.tree.PolicyTreeNode;
import org.eclipse.ditto.model.enforcers.tree.ResourceNode;
import org.eclipse.ditto.model.enforcers.tree.SubjectNode;
import org.eclipse.ditto.model.enforcers.tree.Visitor;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.Subjects;

public final class TreeBasedPolicyEnforcer
implements Enforcer {
    private static final String ROOT_RESOURCE = "/";
    private final Map<String, PolicyTreeNode> tree;

    private TreeBasedPolicyEnforcer(Map<String, PolicyTreeNode> tree) {
        this.tree = tree;
    }

    public static TreeBasedPolicyEnforcer createInstance(Policy policy) {
        ConditionChecker.checkNotNull((Object)policy, (String)"policy");
        HashMap<String, PolicyTreeNode> tree = new HashMap<String, PolicyTreeNode>();
        Set policyEntries = policy.getEntriesSet();
        policyEntries.forEach(policyEntry -> {
            Subjects subjects = policyEntry.getSubjects();
            subjects.forEach(subject -> {
                SubjectId subjectId = subject.getId();
                String subjectIdString = subjectId.toString();
                PolicyTreeNode parentNode = tree.computeIfAbsent(subjectIdString, SubjectNode::of);
                Resources resources = policyEntry.getResources();
                resources.forEach(resource -> {
                    PolicyTreeNode rootChild = parentNode.computeIfAbsent(resource.getType(), t -> {
                        Set emptySet = Collections.emptySet();
                        return ResourceNode.of(parentNode, t, EffectedPermissions.newInstance(emptySet, emptySet));
                    });
                    TreeBasedPolicyEnforcer.addResourceSubTree((ResourceNode)rootChild, resource, resource.getPath());
                });
            });
        });
        return new TreeBasedPolicyEnforcer(tree);
    }

    private static void addResourceSubTree(ResourceNode parentNode, Resource resource, JsonPointer path) {
        if (path.getLevelCount() == 1 || ROOT_RESOURCE.equals(path.toString())) {
            String usedPath;
            String string = usedPath = ROOT_RESOURCE.equals(path.toString()) ? ROOT_RESOURCE : path.getRoot().map(Object::toString).orElseThrow(() -> new NullPointerException("Path did not contain a root!"));
            if (usedPath.equals(ROOT_RESOURCE)) {
                parentNode.getParent().ifPresent(p -> TreeBasedPolicyEnforcer.mergePermissions(resource, parentNode));
            } else if (!parentNode.getChild(usedPath).isPresent()) {
                parentNode.addChild(ResourceNode.of(parentNode, usedPath, resource.getEffectedPermissions()));
            } else {
                ResourceNode existingChild = parentNode.getChild(usedPath).map(ResourceNode.class::cast).orElseThrow(() -> {
                    String msgPattern = "Parent node did not contain a child for path <{}>!";
                    return new NullPointerException(MessageFormat.format("Parent node did not contain a child for path <{}>!", usedPath));
                });
                TreeBasedPolicyEnforcer.mergePermissions(resource, existingChild);
            }
        } else {
            String pathRootAsString = path.getRoot().map(Object::toString).orElse("");
            ResourceNode node = (ResourceNode)parentNode.getChild(pathRootAsString).orElseGet(() -> {
                ResourceNode newChild = ResourceNode.of(parentNode, pathRootAsString);
                parentNode.addChild(newChild);
                return newChild;
            });
            TreeBasedPolicyEnforcer.addResourceSubTree(node, resource, path.nextLevel());
        }
    }

    private static void mergePermissions(Resource resource, ResourceNode existingChild) {
        EffectedPermissions existingChildPermissions = existingChild.getPermissions();
        HashSet mergedGrantedPermissions = new HashSet(existingChildPermissions.getGrantedPermissions());
        HashSet mergedRevokedPermissions = new HashSet(existingChildPermissions.getRevokedPermissions());
        if (!resource.getEffectedPermissions().getRevokedPermissions().isEmpty()) {
            mergedRevokedPermissions.addAll(resource.getEffectedPermissions().getRevokedPermissions());
        }
        if (!resource.getEffectedPermissions().getGrantedPermissions().isEmpty()) {
            mergedGrantedPermissions.addAll(resource.getEffectedPermissions().getGrantedPermissions());
        }
        existingChild.setPermissions(EffectedPermissions.newInstance(mergedGrantedPermissions, mergedRevokedPermissions));
    }

    @Override
    public boolean hasUnrestrictedPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        JsonPointer resourcePointer = TreeBasedPolicyEnforcer.createAbsoluteResourcePointer(resourceKey);
        Collection<String> authSubjectIds = TreeBasedPolicyEnforcer.getAuthorizationSubjectIds(authorizationContext);
        return this.visitTree(new CheckUnrestrictedPermissionsVisitor(resourcePointer, authSubjectIds, permissions));
    }

    private static void checkPermissions(Permissions permissions) {
        ConditionChecker.checkNotNull((Object)permissions, (String)"permissions to check");
    }

    private static JsonPointer createAbsoluteResourcePointer(ResourceKey resourceKey) {
        return JsonFactory.newPointer((CharSequence)resourceKey.getResourceType()).append(resourceKey.getResourcePath());
    }

    private static Collection<String> getAuthorizationSubjectIds(AuthorizationContext authorizationContext) {
        ConditionChecker.checkNotNull((Object)authorizationContext, (String)"Authorization Context");
        return authorizationContext.stream().map(AuthorizationSubject::getId).collect(Collectors.toSet());
    }

    private <T> T visitTree(Visitor<T> visitor) {
        this.tree.values().forEach(policyTreeNode -> policyTreeNode.accept(visitor));
        return visitor.get();
    }

    @Override
    public EffectedSubjectIds getSubjectIdsWithPermission(ResourceKey resourceKey, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        JsonPointer resourcePointer = TreeBasedPolicyEnforcer.createAbsoluteResourcePointer(resourceKey);
        return this.visitTree(new CollectEffectedSubjectIdsVisitor(resourcePointer, permissions));
    }

    @Override
    public EffectedSubjects getSubjectsWithPermission(ResourceKey resourceKey, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        JsonPointer resourcePointer = TreeBasedPolicyEnforcer.createAbsoluteResourcePointer(resourceKey);
        return this.visitTree(new CollectEffectedSubjectsVisitor(resourcePointer, permissions));
    }

    private static void checkResourceKey(ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"resource key");
    }

    @Override
    public Set<String> getSubjectIdsWithPartialPermission(ResourceKey resourceKey, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        JsonPointer resourcePointer = TreeBasedPolicyEnforcer.createAbsoluteResourcePointer(resourceKey);
        return this.visitTree(new CollectPartialGrantedSubjectIdsVisitor(resourcePointer, permissions));
    }

    @Override
    public Set<AuthorizationSubject> getSubjectsWithPartialPermission(ResourceKey resourceKey, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        JsonPointer resourcePointer = TreeBasedPolicyEnforcer.createAbsoluteResourcePointer(resourceKey);
        return this.visitTree(new CollectPartialGrantedSubjectsVisitor(resourcePointer, permissions));
    }

    @Override
    public boolean hasPartialPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        Collection<String> authSubjectIds = TreeBasedPolicyEnforcer.getAuthorizationSubjectIds(authorizationContext);
        JsonPointer resourcePointer = TreeBasedPolicyEnforcer.createAbsoluteResourcePointer(resourceKey);
        return this.visitTree(new CheckPartialPermissionsVisitor(resourcePointer, authSubjectIds, permissions));
    }

    @Override
    public JsonObject buildJsonView(ResourceKey resourceKey, Iterable<JsonField> jsonFields, AuthorizationContext authorizationContext, Permissions permissions) {
        TreeBasedPolicyEnforcer.checkResourceKey(resourceKey);
        ConditionChecker.checkNotNull(jsonFields, (String)"JSON fields");
        TreeBasedPolicyEnforcer.checkPermissions(permissions);
        Collection<String> authorizationSubjectIds = TreeBasedPolicyEnforcer.getAuthorizationSubjectIds(authorizationContext);
        EffectedResources effectedResources = this.getGrantedAndRevokedSubResource(JsonFactory.newPointer((CharSequence)ROOT_RESOURCE), resourceKey.getResourceType(), authorizationSubjectIds, permissions);
        if (jsonFields instanceof JsonObject && ((JsonObject)jsonFields).isNull()) {
            return JsonFactory.nullObject();
        }
        ArrayList flatPointers = new ArrayList();
        jsonFields.forEach(jsonField -> TreeBasedPolicyEnforcer.collectFlatPointers(jsonField.getKey().asPointer(), jsonField, flatPointers));
        Set<JsonPointer> grantedResources = TreeBasedPolicyEnforcer.extractJsonPointers(effectedResources.getGrantedResources());
        Set<JsonPointer> revokedResources = TreeBasedPolicyEnforcer.extractJsonPointers(effectedResources.getRevokedResources());
        JsonPointer resourcePath = resourceKey.getResourcePath();
        List<PointerAndValue> prefixedPointers = flatPointers.stream().map(pv -> new PointerAndValue(resourcePath.append(((PointerAndValue)pv).pointer), ((PointerAndValue)pv).value)).collect(Collectors.toList());
        return TreeBasedPolicyEnforcer.filterEntries(prefixedPointers, grantedResources, revokedResources, resourcePath);
    }

    private static Set<JsonPointer> extractJsonPointers(Collection<PointerAndPermission> resources) {
        return resources.stream().map(pointerAndPermission -> ((PointerAndPermission)pointerAndPermission).pointer).collect(Collectors.toSet());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [tree=" + this.tree + "]";
    }

    private static List<PointerAndValue> collectFlatPointers(JsonPointer createdPointer, JsonField field, List<PointerAndValue> flattenedFields) {
        JsonValue fieldValue = field.getValue();
        if (fieldValue.isObject()) {
            JsonObject jsonObject = fieldValue.asObject();
            if (!jsonObject.isEmpty()) {
                jsonObject.forEach(jsonField -> TreeBasedPolicyEnforcer.collectFlatPointers(createdPointer.addLeaf(jsonField.getKey()), jsonField, flattenedFields));
            } else {
                flattenedFields.add(new PointerAndValue(createdPointer, fieldValue));
            }
        } else {
            flattenedFields.add(new PointerAndValue(createdPointer, fieldValue));
        }
        return flattenedFields;
    }

    private static JsonObject filterEntries(Collection<PointerAndValue> candidates, Collection<JsonPointer> grantedResources, Collection<JsonPointer> revokedResources, JsonPointer resourcePath) {
        int levelCount = resourcePath.getLevelCount();
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder();
        candidates.stream().filter(pointerAndValue -> ((PointerAndValue)pointerAndValue).pointer.toString().startsWith(resourcePath.toString())).filter(pointerAndValue -> {
            JsonPointer rootResourcePointer = JsonFactory.newPointer((CharSequence)ROOT_RESOURCE);
            boolean accessible = grantedResources.contains(rootResourcePointer) && !revokedResources.contains(rootResourcePointer);
            JsonPointer pointer = ((PointerAndValue)pointerAndValue).pointer;
            for (int i = 1; i <= pointer.getLevelCount(); ++i) {
                if (TreeBasedPolicyEnforcer.containsPrefixPointer(TreeBasedPolicyEnforcer.getPrefixPointerOrThrow(pointer, i), grantedResources)) {
                    accessible = true;
                }
                if (!TreeBasedPolicyEnforcer.containsPrefixPointer(TreeBasedPolicyEnforcer.getPrefixPointerOrThrow(pointer, i), revokedResources)) continue;
                accessible = false;
            }
            return accessible;
        }).forEach(pointerAndValue -> {
            JsonPointer subPointer = (JsonPointer)((PointerAndValue)pointerAndValue).pointer.getSubPointer(levelCount).orElseThrow(() -> {
                String msgPattern = "JsonPointer did not contain a sub-pointer for level <{0}>!";
                return new NullPointerException(MessageFormat.format("JsonPointer did not contain a sub-pointer for level <{0}>!", levelCount));
            });
            builder.set((CharSequence)resourcePath.append(subPointer), ((PointerAndValue)pointerAndValue).value);
        });
        return builder.build().getValue((CharSequence)resourcePath).filter(JsonValue::isObject).map(JsonValue::asObject).orElseGet(JsonFactory::newObject);
    }

    private static JsonPointer getPrefixPointerOrThrow(JsonPointer pointer, int level) {
        return (JsonPointer)pointer.getPrefixPointer(level).orElseThrow(() -> {
            String msgPatten = "JsonPointer did not contain a prefix pointer for level <{0}>!";
            return new NullPointerException(MessageFormat.format("JsonPointer did not contain a prefix pointer for level <{0}>!", level));
        });
    }

    private static boolean containsPrefixPointer(JsonPointer prefix, Collection<JsonPointer> resources) {
        return resources.stream().anyMatch(p -> p.equals(prefix));
    }

    private EffectedResources getGrantedAndRevokedSubResource(JsonPointer resource, String type, Iterable<String> subjectIds, Permissions permissions) {
        HashSet<PointerAndPermission> revokedResources = new HashSet<PointerAndPermission>();
        Set grantedResources = permissions.stream().map(permission -> {
            EffectedResources result = this.checkPermissionOnAnySubResource(resource, type, subjectIds, (String)permission);
            revokedResources.addAll(result.getRevokedResources());
            return result.getGrantedResources();
        }).reduce(TreeBasedPolicyEnforcer::retainElements).orElseGet(Collections::emptySet);
        Set<PointerAndPermission> clearedGrantedResources = TreeBasedPolicyEnforcer.removeDeeperRevokes(resource, grantedResources, revokedResources);
        return EffectedResources.of(clearedGrantedResources, revokedResources);
    }

    private static Set<PointerAndPermission> removeDeeperRevokes(JsonPointer resource, Iterable<PointerAndPermission> grantedResources, Collection<PointerAndPermission> revokedResources) {
        HashSet<PointerAndPermission> cleared = new HashSet<PointerAndPermission>();
        grantedResources.forEach(pp -> {
            JsonPointer pointer = ((PointerAndPermission)pp).pointer;
            if (revokedResources.stream().noneMatch(rp -> resource.getLevelCount() > pointer.getLevelCount() && ((PointerAndPermission)rp).permission.equals(((PointerAndPermission)pp).permission) && ((PointerAndPermission)rp).pointer.getLevelCount() >= pointer.getLevelCount() && Objects.equals(TreeBasedPolicyEnforcer.getPrefixPointerOrThrow(((PointerAndPermission)rp).pointer, pointer.getLevelCount()), pointer))) {
                cleared.add((PointerAndPermission)pp);
            }
        });
        return cleared;
    }

    private static Set<PointerAndPermission> retainElements(Collection<PointerAndPermission> grans1, Collection<PointerAndPermission> grans2) {
        Set grans2Pointers = grans2.stream().map(pp -> ((PointerAndPermission)pp).pointer).collect(Collectors.toSet());
        return grans1.stream().filter(pp -> grans2Pointers.contains(((PointerAndPermission)pp).pointer)).collect(Collectors.toSet());
    }

    private EffectedResources checkPermissionOnAnySubResource(JsonPointer resourcePath, String resourceType, Iterable<String> subjectIds, String permission) {
        HashSet<PointerAndPermission> grantedResources = new HashSet<PointerAndPermission>();
        HashSet<PointerAndPermission> revokedResources = new HashSet<PointerAndPermission>();
        subjectIds.forEach(s -> TreeBasedPolicyEnforcer.traverseSubtreeForPermissionAccess(permission, resourcePath, resourceType, this.tree.get(s), grantedResources, revokedResources, 0, true));
        return EffectedResources.of(grantedResources, revokedResources);
    }

    private static void traverseSubtreeForPermissionAccess(String permission, JsonPointer resource, String type, @Nullable PolicyTreeNode policyTreeNode, Set<PointerAndPermission> grantedResources, Set<PointerAndPermission> revokedResources, int level, boolean followingResource) {
        if (policyTreeNode == null) {
            return;
        }
        if (policyTreeNode instanceof SubjectNode) {
            Optional<PolicyTreeNode> nodeChildOptional = policyTreeNode.getChild(type);
            if (ROOT_RESOURCE.equals(resource.toString())) {
                nodeChildOptional.ifPresent(policyTreeNode1 -> TreeBasedPolicyEnforcer.traverseSubtreeForPermissionAccess(permission, resource, type, policyTreeNode1, grantedResources, revokedResources, level, false));
            } else if (nodeChildOptional.isPresent()) {
                TreeBasedPolicyEnforcer.traverseSubtreeForPermissionAccess(permission, resource, type, nodeChildOptional.get(), grantedResources, revokedResources, level, true);
            } else {
                resource.get(level).ifPresent(jsonKey -> policyTreeNode.getChild(jsonKey.toString()).ifPresent(child -> TreeBasedPolicyEnforcer.traverseSubtreeForPermissionAccess(permission, resource, type, child, grantedResources, revokedResources, level + 1, true)));
            }
        } else {
            ResourceNode resourceNode = (ResourceNode)policyTreeNode;
            TreeBasedPolicyEnforcer.addPermission(permission, resource, grantedResources, revokedResources, level, resourceNode);
            Optional jsonKeyOptional = resource.get(level);
            if (followingResource && jsonKeyOptional.isPresent()) {
                policyTreeNode.getChild(((JsonKey)jsonKeyOptional.get()).toString()).ifPresent(child -> TreeBasedPolicyEnforcer.traverseSubtreeForPermissionAccess(permission, resource, type, child, grantedResources, revokedResources, level + 1, true));
            } else {
                policyTreeNode.getChildren().forEach((s, child) -> TreeBasedPolicyEnforcer.traverseSubtreeForPermissionAccess(permission, resource.addLeaf(JsonKey.of((CharSequence)s)), type, child, grantedResources, revokedResources, level + 1, false));
            }
        }
    }

    private static void addPermission(String permission, JsonPointer resource, Collection<PointerAndPermission> grantedResources, Collection<PointerAndPermission> revokedResources, int level, ResourceNode resourceNode) {
        JsonPointer resourceToAdd = ROOT_RESOURCE.equals(resource.toString()) ? JsonFactory.newPointer((CharSequence)ROOT_RESOURCE) : TreeBasedPolicyEnforcer.getPrefixPointerOrThrow(resource, level);
        EffectedPermissions effectedPermissions = resourceNode.getPermissions();
        if (effectedPermissions.getGrantedPermissions().contains((Object)permission)) {
            grantedResources.add(new PointerAndPermission(resourceToAdd, permission));
        }
        if (effectedPermissions.getRevokedPermissions().contains((Object)permission)) {
            revokedResources.add(new PointerAndPermission(resourceToAdd, permission));
        }
    }

    @Immutable
    static final class PointerAndPermission {
        private final JsonPointer pointer;
        private final String permission;

        PointerAndPermission(JsonPointer pointer, String permission) {
            this.pointer = pointer;
            this.permission = permission;
        }
    }

    @Immutable
    private static final class PointerAndValue {
        private final JsonPointer pointer;
        private final JsonValue value;

        PointerAndValue(JsonPointer pointer, JsonValue value) {
            this.pointer = pointer;
            this.value = value;
        }
    }
}

