/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;

@ParametersAreNonnullByDefault
@Immutable
final class WeightedPermission {
    private final String permission;
    private final int weight;

    private WeightedPermission(String thePermission, int theWeight) {
        this.permission = thePermission;
        this.weight = theWeight;
    }

    public static WeightedPermission of(CharSequence permission, int weight) {
        ConditionChecker.argumentNotEmpty((CharSequence)permission, (String)"permission");
        return new WeightedPermission(permission.toString(), weight);
    }

    public String getPermission() {
        return this.permission;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedPermission that = (WeightedPermission)o;
        return this.weight == that.weight && Objects.equals(this.permission, that.permission);
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.weight);
    }

    public String toString() {
        return "(" + this.permission + ", " + this.weight + ")";
    }
}

