/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.tree;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.tree.WeightedPermission;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class WeightedPermissions {
    private final Set<WeightedPermission> granted = new HashSet<WeightedPermission>();
    private final Set<WeightedPermission> revoked = new HashSet<WeightedPermission>();

    public Set<WeightedPermission> getAllGranted() {
        return this.granted;
    }

    public Map<String, WeightedPermission> getGrantedWithHighestWeight(Collection<String> permissions) {
        return WeightedPermissions.getWithHighestWeight(this.getAllGranted(), permissions);
    }

    private static Map<String, WeightedPermission> getWithHighestWeight(Collection<WeightedPermission> allWeightedPermissions, Collection<String> expectedPermissions) {
        HashMap<String, WeightedPermission> result = new HashMap<String, WeightedPermission>(expectedPermissions.size());
        Map<String, List<WeightedPermission>> groupedByPermission = allWeightedPermissions.stream().collect(Collectors.groupingBy(WeightedPermission::getPermission));
        for (String expectedPermission : expectedPermissions) {
            List<WeightedPermission> weightedPermissions = groupedByPermission.get(expectedPermission);
            if (null == weightedPermissions) continue;
            weightedPermissions.stream().sorted(Comparator.comparingInt(WeightedPermission::getWeight).reversed()).findFirst().ifPresent(wp -> result.put(wp.getPermission(), (WeightedPermission)wp));
        }
        return result;
    }

    public void addGranted(WeightedPermission weightedPermission) {
        ConditionChecker.checkNotNull((Object)weightedPermission, (String)"granted permission to be added");
        this.granted.add(weightedPermission);
    }

    public void addGranted(CharSequence permission, int weight) {
        this.addGranted(WeightedPermission.of(permission, weight));
    }

    public void addGranted(Iterable<String> permissions, int weight) {
        for (CharSequence charSequence : permissions) {
            this.addGranted(charSequence, weight);
        }
    }

    public Set<WeightedPermission> getAllRevoked() {
        return this.revoked;
    }

    public Map<String, WeightedPermission> getRevokedWithHighestWeight(Collection<String> permissions) {
        return WeightedPermissions.getWithHighestWeight(this.getAllRevoked(), permissions);
    }

    public void addRevoked(WeightedPermission weightedPermission) {
        ConditionChecker.checkNotNull((Object)weightedPermission, (String)"revoked permission to be added");
        this.revoked.add(weightedPermission);
    }

    public void addRevoked(CharSequence permission, int weight) {
        this.addRevoked(WeightedPermission.of(permission, weight));
    }

    public void addRevoked(Iterable<String> permissions, int weight) {
        for (CharSequence charSequence : permissions) {
            this.addRevoked(charSequence, weight);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [granted=" + this.granted + ", revoked=" + this.revoked + "]";
    }
}

