/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.trie;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.DefaultEffectedSubjects;
import org.eclipse.ditto.model.enforcers.EffectedSubjectIds;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;
import org.eclipse.ditto.model.enforcers.ImmutableEffectedSubjectIds;
import org.eclipse.ditto.model.enforcers.trie.PermissionSubjectsMap;

final class GrantRevokeIndex {
    private final PermissionSubjectsMap grantMap;
    private final PermissionSubjectsMap revokeMap;

    GrantRevokeIndex() {
        this(new PermissionSubjectsMap(), new PermissionSubjectsMap());
    }

    GrantRevokeIndex(PermissionSubjectsMap grantMap, PermissionSubjectsMap revokeMap) {
        this.grantMap = (PermissionSubjectsMap)ConditionChecker.checkNotNull((Object)grantMap, (String)"grant map");
        this.revokeMap = (PermissionSubjectsMap)ConditionChecker.checkNotNull((Object)revokeMap, (String)"revoke map");
    }

    PermissionSubjectsMap getGranted() {
        return this.grantMap;
    }

    PermissionSubjectsMap getRevoked() {
        return this.revokeMap;
    }

    GrantRevokeIndex copyWithDecrementedWeight() {
        return new GrantRevokeIndex(this.grantMap.copyWithDecrementedWeight(), this.revokeMap.copyWithDecrementedWeight());
    }

    GrantRevokeIndex overrideBy(GrantRevokeIndex update) {
        ConditionChecker.checkNotNull((Object)update, (String)"update");
        this.grantMap.addAllEntriesFrom(update.grantMap).removeAllEntriesFrom(update.revokeMap);
        this.revokeMap.removeAllEntriesFrom(update.grantMap).addAllEntriesFrom(update.revokeMap);
        return this;
    }

    boolean hasPermissions(Collection<String> subjectIds, Collection<String> permissions) {
        Optional<Integer> grantWeight = this.grantMap.getMaxNonemptyWeightForAllPermissions(subjectIds, permissions);
        Optional<Integer> revokeWeight = this.revokeMap.getMaxWeightForAllPermissions(subjectIds, permissions);
        return grantWeight.isPresent() && (!revokeWeight.isPresent() || revokeWeight.get() < grantWeight.get());
    }

    @Deprecated
    EffectedSubjectIds getEffectedSubjectIds(Set<String> permissions) {
        Set<String> grantedSubjectIds = this.getGrantedSubjectIds(permissions);
        Set<String> revokedSubjectIds = this.getRevokedSubjectIds(permissions);
        return ImmutableEffectedSubjectIds.of(grantedSubjectIds, revokedSubjectIds);
    }

    EffectedSubjects getEffectedSubjects(Set<String> permissions) {
        return DefaultEffectedSubjects.of(this.getGrantedSubjects(permissions), this.getRevokedSubjects(permissions));
    }

    @Deprecated
    Set<String> getGrantedSubjectIds(Set<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions to check");
        return this.grantMap.getSubjectIntersect(permissions).keySet();
    }

    Set<AuthorizationSubject> getGrantedSubjects(Set<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions to check");
        return GrantRevokeIndex.getAuthorizationSubjects(this.grantMap.getSubjectIntersect(permissions).keySet());
    }

    private static Set<AuthorizationSubject> getAuthorizationSubjects(Collection<String> authSubjectIds) {
        return authSubjectIds.stream().map(AuthorizationSubject::newInstance).collect(Collectors.toSet());
    }

    @Deprecated
    Set<String> getRevokedSubjectIds(Set<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions to check");
        return this.revokeMap.getSubjectUnion(permissions).keySet();
    }

    Set<AuthorizationSubject> getRevokedSubjects(Set<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions to check");
        return GrantRevokeIndex.getAuthorizationSubjects(this.revokeMap.getSubjectUnion(permissions).keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantRevokeIndex that = (GrantRevokeIndex)o;
        return Objects.equals(this.grantMap, that.grantMap) && Objects.equals(this.revokeMap, that.revokeMap);
    }

    public int hashCode() {
        return Objects.hash(this.grantMap, this.revokeMap);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [grantMap=" + this.grantMap + ", revokeMap=" + this.revokeMap + "]";
    }
}

