/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.trie;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;

@NotThreadSafe
final class PermissionSubjectsMap
extends AbstractMap<String, Map<String, Integer>> {
    private final Map<String, Map<String, Integer>> data = new HashMap<String, Map<String, Integer>>();

    PermissionSubjectsMap() {
    }

    @Override
    public Set<Map.Entry<String, Map<String, Integer>>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Map<String, Integer> put(String key, Map<String, Integer> value) {
        return this.data.put((String)ConditionChecker.checkNotNull((Object)key, (String)"key"), (Map)ConditionChecker.checkNotNull(value, (String)"value"));
    }

    void addTotalRelationOfWeightZero(Iterable<String> permissions, Collection<String> subjectIds) {
        PermissionSubjectsMap.validatePermissions(permissions);
        PermissionSubjectsMap.validateSubjectIds(subjectIds);
        Map subjectsWithDefaultWeight = subjectIds.stream().collect(Collectors.toMap(Function.identity(), subject -> 0));
        permissions.forEach((? super T permission) -> this.addPermissionSubjects((String)permission, subjectsWithDefaultWeight));
    }

    Optional<Integer> getMaxWeightForAllPermissions(Collection<String> subjectIds, Collection<String> permissions) {
        PermissionSubjectsMap.validateSubjectIds(subjectIds);
        PermissionSubjectsMap.validatePermissions(permissions);
        return permissions.stream().flatMap(permission -> {
            Map permittedSubjects = this.getOrDefault(permission, Collections.emptyMap());
            return PermissionSubjectsMap.intersect(subjectIds, permittedSubjects.keySet()).map(permittedSubjects::get);
        }).max(Comparator.naturalOrder());
    }

    Optional<Integer> getMaxNonemptyWeightForAllPermissions(Collection<String> subjectIds, Collection<String> permissions) {
        PermissionSubjectsMap.validateSubjectIds(subjectIds);
        PermissionSubjectsMap.validatePermissions(permissions);
        List permissionWeights = permissions.stream().map(permission -> {
            Map permittedSubjects = this.getOrDefault(permission, Collections.emptyMap());
            return PermissionSubjectsMap.intersect(subjectIds, permittedSubjects.keySet()).map(permittedSubjects::get).max(Comparator.naturalOrder());
        }).collect(Collectors.toList());
        if (permissionWeights.stream().anyMatch(maybeWeight -> !maybeWeight.isPresent())) {
            return Optional.empty();
        }
        return permissionWeights.stream().map(Optional::get).max(Comparator.naturalOrder());
    }

    Map<String, Integer> getSubjectUnion(Set<String> permissions) {
        PermissionSubjectsMap.validatePermissions(permissions);
        HashMap<String, Integer> subjectUnion = new HashMap<String, Integer>();
        PermissionSubjectsMap.intersect(this.keySet(), permissions).flatMap(permission -> ((Map)this.get(permission)).entrySet().stream()).forEach((? super T entry) -> subjectUnion.compute((String)entry.getKey(), (subject, weight) -> weight == null ? (Integer)entry.getValue() : Math.max((Integer)entry.getValue(), weight)));
        return subjectUnion;
    }

    Map<String, Integer> getSubjectIntersect(Set<String> permissions) {
        PermissionSubjectsMap.validatePermissions(permissions);
        Stream<Map> subjectsOfPermissions = PermissionSubjectsMap.intersect(this.keySet(), permissions).map(this::get);
        Optional<Map> reduceResult = subjectsOfPermissions.reduce((map1, map2) -> PermissionSubjectsMap.intersect(map1.keySet(), map2.keySet()).collect(Collectors.toMap(Function.identity(), key -> Math.max((Integer)map1.get(key), (Integer)map2.get(key)))));
        return reduceResult.orElse(Collections.emptyMap());
    }

    PermissionSubjectsMap copy() {
        PermissionSubjectsMap copy = new PermissionSubjectsMap();
        this.forEach((permission, subjectMap) -> copy.put((String)permission, (Map<String, Integer>)new HashMap<String, Integer>((Map<String, Integer>)subjectMap)));
        return copy;
    }

    PermissionSubjectsMap copyWithIncrementedWeight() {
        return this.copyWithWeightAdjustment(1);
    }

    PermissionSubjectsMap copyWithDecrementedWeight() {
        return this.copyWithWeightAdjustment(-1);
    }

    PermissionSubjectsMap removeAllEntriesFrom(PermissionSubjectsMap update) {
        ConditionChecker.checkNotNull((Object)update, (String)"relation to be deleted");
        update.forEach((permission, subjectMap) -> this.removePermissionSubjects((String)permission, (Iterable<String>)subjectMap.keySet()));
        return this;
    }

    private void removePermissionSubjects(String permission, Iterable<String> subjectIds) {
        this.compute(permission, (p, subjectMap) -> {
            if (subjectMap == null) {
                return null;
            }
            subjectIds.forEach(subjectMap::remove);
            return subjectMap;
        });
    }

    PermissionSubjectsMap addAllEntriesFrom(PermissionSubjectsMap other) {
        ConditionChecker.checkNotNull((Object)other, (String)"relation to be added");
        other.forEach(this::addPermissionSubjects);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PermissionSubjectsMap that = (PermissionSubjectsMap)o;
        return Objects.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data);
    }

    private static void validateSubjectIds(Collection<String> subjectIds) {
        ConditionChecker.checkNotNull(subjectIds, (String)"subject IDs to check");
    }

    private static void validatePermissions(Object permissions) {
        ConditionChecker.checkNotNull((Object)permissions, (String)"permissions to check");
    }

    private void addPermissionSubjects(String permission, Map<String, Integer> subjects) {
        this.compute(permission, (p, subjectMap) -> {
            if (subjectMap == null) {
                return new HashMap(subjects);
            }
            subjects.forEach((subject, thatWeight) -> subjectMap.compute(subject, (s, thisWeight) -> thisWeight == null ? thatWeight : Math.max(thisWeight, thatWeight)));
            return subjectMap;
        });
    }

    private static <T> Stream<T> intersect(Collection<T> set1, Collection<T> set2) {
        return set1.size() <= set2.size() ? set1.stream().filter(set2::contains) : set2.stream().filter(set1::contains);
    }

    private PermissionSubjectsMap copyWithWeightAdjustment(int adjustment) {
        PermissionSubjectsMap copy = new PermissionSubjectsMap();
        this.forEach((permission, subjectMap) -> {
            Map<String, Integer> adjustedSubjectMap = subjectMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Integer)entry.getValue() + adjustment));
            copy.put((String)permission, adjustedSubjectMap);
        });
        return copy;
    }
}

