/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.trie;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.json.JsonValueContainer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.trie.GrantRevokeIndex;
import org.eclipse.ditto.model.enforcers.trie.PermissionSubjectsMap;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.Subjects;

@NotThreadSafe
final class PolicyTrie {
    private final GrantRevokeIndex grantRevokeIndex;
    private final Map<JsonKey, PolicyTrie> children;

    private PolicyTrie() {
        this(new GrantRevokeIndex(), new HashMap<JsonKey, PolicyTrie>());
    }

    private PolicyTrie(GrantRevokeIndex grantRevokeIndex, Map<JsonKey, PolicyTrie> children) {
        this.grantRevokeIndex = grantRevokeIndex;
        this.children = children;
    }

    static PolicyTrie fromPolicy(Iterable<PolicyEntry> policy) {
        ConditionChecker.checkNotNull(policy, (String)"policy to interpret");
        PolicyTrie prototype = new PolicyTrie();
        policy.forEach(prototype::addPolicyEntry);
        return prototype;
    }

    private void addPolicyEntry(PolicyEntry policyEntry) {
        Collection<String> subjectIds = PolicyTrie.getSubjectIds(policyEntry.getSubjects());
        policyEntry.getResources().forEach(resource -> {
            PolicyTrie target = this.seekOrCreate(PolicyTrie.getJsonKeyIterator(resource.getResourceKey()));
            EffectedPermissions effectedPermissions = resource.getEffectedPermissions();
            target.grant(subjectIds, (Iterable<String>)effectedPermissions.getGrantedPermissions());
            target.revoke(subjectIds, (Iterable<String>)effectedPermissions.getRevokedPermissions());
        });
    }

    private static Collection<String> getSubjectIds(Subjects subjects) {
        return subjects.stream().map(Subject::getId).map(SubjectId::toString).collect(Collectors.toSet());
    }

    static Iterator<JsonKey> getJsonKeyIterator(ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"resource key to convert");
        return JsonFactory.newPointer((CharSequence)resourceKey.getResourceType()).append(resourceKey.getResourcePath()).iterator();
    }

    private PolicyTrie seekOrCreate(Iterator<JsonKey> path) {
        return path.hasNext() ? this.computeForChild(path) : this;
    }

    private PolicyTrie computeForChild(Iterator<JsonKey> path) {
        PolicyTrie childNode = this.compute(path.next(), Function.identity());
        return childNode.seekOrCreate(path);
    }

    private PolicyTrie compute(JsonKey childKey, Function<PolicyTrie, PolicyTrie> childUpdate) {
        return this.children.compute(childKey, (? super K key, ? super V childTrie) -> childTrie == null ? new PolicyTrie() : (PolicyTrie)childUpdate.apply((PolicyTrie)childTrie));
    }

    private void grant(Collection<String> subjectIds, Iterable<String> permissions) {
        this.grantRevokeIndex.getGranted().addTotalRelationOfWeightZero(permissions, subjectIds);
    }

    private void revoke(Collection<String> subjectIds, Iterable<String> permissions) {
        this.grantRevokeIndex.getRevoked().addTotalRelationOfWeightZero(permissions, subjectIds);
    }

    GrantRevokeIndex getGrantRevokeIndex() {
        return this.grantRevokeIndex;
    }

    PolicyTrie getTransitiveClosure() {
        return PolicyTrie.computeTransitiveClosure(this, new GrantRevokeIndex());
    }

    private static PolicyTrie computeTransitiveClosure(PolicyTrie thisTrie, GrantRevokeIndex inherited) {
        GrantRevokeIndex thisMap = inherited.copyWithDecrementedWeight().overrideBy(thisTrie.grantRevokeIndex);
        HashMap<JsonKey, PolicyTrie> newChildren = new HashMap<JsonKey, PolicyTrie>(thisTrie.children.size());
        thisTrie.children.forEach((key, oldChild) -> newChildren.put((JsonKey)key, PolicyTrie.computeTransitiveClosure(oldChild, thisMap)));
        return new PolicyTrie(thisMap, newChildren);
    }

    PolicyTrie getBottomUpGrantTrie() {
        HashMap<JsonKey, PolicyTrie> newChildren = new HashMap<JsonKey, PolicyTrie>(this.children.size());
        PermissionSubjectsMap newGrantMap = this.grantRevokeIndex.getGranted().copy();
        this.children.forEach((key, oldChild) -> {
            PolicyTrie newChild = oldChild.getBottomUpGrantTrie();
            newChildren.put((JsonKey)key, newChild);
            GrantRevokeIndex newChildGrantRevokeIndex = newChild.getGrantRevokeIndex();
            PermissionSubjectsMap granted = newChildGrantRevokeIndex.getGranted();
            newGrantMap.addAllEntriesFrom(granted.copyWithIncrementedWeight());
        });
        PermissionSubjectsMap newRevokeMap = this.grantRevokeIndex.getRevoked().copy();
        newRevokeMap.removeAllEntriesFrom(newGrantMap);
        GrantRevokeIndex newGrantRevokeMap = new GrantRevokeIndex(newGrantMap, newRevokeMap);
        return new PolicyTrie(newGrantRevokeMap, newChildren);
    }

    PolicyTrie getBottomUpRevokeTrie() {
        HashMap<JsonKey, PolicyTrie> newChildren = new HashMap<JsonKey, PolicyTrie>(this.children.size());
        PermissionSubjectsMap newRevokeMap = this.grantRevokeIndex.getRevoked().copy();
        this.children.forEach((key, oldChild) -> {
            PolicyTrie newChild = oldChild.getBottomUpRevokeTrie();
            newChildren.put((JsonKey)key, newChild);
            GrantRevokeIndex newChildGrantRevokeIndex = newChild.getGrantRevokeIndex();
            PermissionSubjectsMap revoked = newChildGrantRevokeIndex.getRevoked();
            newRevokeMap.addAllEntriesFrom(revoked.copyWithIncrementedWeight());
        });
        PermissionSubjectsMap newGrantMap = this.grantRevokeIndex.getGranted().copy();
        GrantRevokeIndex newGrantRevokeMap = new GrantRevokeIndex(newGrantMap, newRevokeMap);
        return new PolicyTrie(newGrantRevokeMap, newChildren);
    }

    boolean hasChild(JsonKey childKey) {
        return this.children.containsKey(childKey);
    }

    JsonObject buildJsonView(Iterable<JsonField> jsonFields, Collection<String> subjectIds, Permissions permissions) {
        PolicyTrie defaultPolicyTrie = new PolicyTrie(this.grantRevokeIndex, Collections.emptyMap());
        if (jsonFields instanceof JsonObject && ((JsonObject)jsonFields).isNull()) {
            return (JsonObject)jsonFields;
        }
        JsonObjectBuilder outputObjectBuilder = JsonFactory.newObjectBuilder();
        for (JsonField field : jsonFields) {
            JsonValue jsonView = this.getViewForJsonFieldOrNull(field, defaultPolicyTrie, subjectIds, permissions);
            if (null == jsonView) continue;
            outputObjectBuilder.set((CharSequence)field.getKey(), jsonView);
        }
        return outputObjectBuilder.build();
    }

    @Nullable
    private JsonValue getViewForJsonFieldOrNull(JsonField jsonField, PolicyTrie defaultPolicyTrie, Collection<String> subjectIds, Permissions permissions) {
        PolicyTrie relevantTrie = this.children.getOrDefault(jsonField.getKey(), defaultPolicyTrie);
        return relevantTrie.getViewForJsonValueOrNull(jsonField.getValue(), subjectIds, permissions);
    }

    @Nullable
    private JsonValue getViewForJsonValueOrNull(JsonValue jsonValue, Collection<String> subjectIds, Permissions permissions) {
        Object result = jsonValue.isObject() ? this.getViewForJsonObjectOrNull((Iterable<JsonField>)jsonValue.asObject(), subjectIds, permissions) : (jsonValue.isArray() ? this.getViewForJsonArrayOrNull((JsonValueContainer<JsonValue>)jsonValue.asArray(), subjectIds, permissions) : (this.grantRevokeIndex.hasPermissions(subjectIds, (Collection<String>)permissions) ? jsonValue : null));
        return result;
    }

    @Nullable
    private JsonValue getViewForJsonObjectOrNull(Iterable<JsonField> jsonObject, Collection<String> subjectIds, Permissions permissions) {
        return this.filterCandidate(this.buildJsonView(jsonObject, subjectIds, permissions), subjectIds, (Collection<String>)permissions);
    }

    @Nullable
    private <T extends JsonValue & JsonValueContainer> T filterCandidate(T candidate, Collection<String> subjectIds, Collection<String> permissions) {
        if (!((JsonValueContainer)candidate).isEmpty() || this.grantRevokeIndex.hasPermissions(subjectIds, permissions)) {
            return candidate;
        }
        return null;
    }

    @Nullable
    private JsonValue getViewForJsonArrayOrNull(JsonValueContainer<JsonValue> jsonArray, Collection<String> subjectIds, Permissions permissions) {
        JsonArray candidate = (JsonArray)jsonArray.stream().map(value -> this.getViewForJsonValueOrNull((JsonValue)value, subjectIds, permissions)).filter(Objects::nonNull).collect(JsonCollectors.valuesToArray());
        return this.filterCandidate(candidate, subjectIds, (Collection<String>)permissions);
    }

    PolicyTrie seekToLeastAncestor(Iterator<JsonKey> path) {
        return (PolicyTrie)this.seek(path, Function.identity(), Function.identity());
    }

    Optional<PolicyTrie> seekToExactNode(Iterator<JsonKey> path) {
        return this.seek(path, Optional::of, ancestor -> Optional.empty());
    }

    private <T> T seek(Iterator<JsonKey> path, Function<PolicyTrie, T> endOfPath, Function<PolicyTrie, T> endOfTrie) {
        JsonKey key;
        PolicyTrie policyTrie;
        T result = path.hasNext() ? (null != (policyTrie = this.children.get(key = path.next())) ? policyTrie.seek(path, endOfPath, endOfTrie) : endOfTrie.apply(this)) : endOfPath.apply(this);
        return result;
    }
}

