/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.enforcers.trie;

import java.util.Collection;
import java.util.Set;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.enforcers.EffectedSubjectIds;
import org.eclipse.ditto.model.enforcers.EffectedSubjects;
import org.eclipse.ditto.model.enforcers.Enforcer;
import org.eclipse.ditto.model.enforcers.trie.GrantRevokeIndex;
import org.eclipse.ditto.model.enforcers.trie.PolicyTrie;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.ResourceKey;

public final class TrieBasedPolicyEnforcer
implements Enforcer {
    private final PolicyTrie inheritedTrie;
    private final PolicyTrie bottomUpGrantTrie;
    private final PolicyTrie bottomUpRevokeTrie;

    private TrieBasedPolicyEnforcer(Iterable<PolicyEntry> policy) {
        PolicyTrie rawTree = PolicyTrie.fromPolicy(policy);
        this.inheritedTrie = rawTree.getTransitiveClosure();
        this.bottomUpGrantTrie = this.inheritedTrie.getBottomUpGrantTrie();
        this.bottomUpRevokeTrie = this.inheritedTrie.getBottomUpRevokeTrie();
    }

    public static TrieBasedPolicyEnforcer newInstance(Policy policy) {
        return new TrieBasedPolicyEnforcer((Iterable)ConditionChecker.checkNotNull((Object)policy, (String)"policy to interpret"));
    }

    @Override
    public boolean hasUnrestrictedPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, Permissions permissions) {
        PolicyTrie policyTrie = TrieBasedPolicyEnforcer.seekWithFallback(resourceKey, this.bottomUpRevokeTrie, this.inheritedTrie);
        GrantRevokeIndex grantRevokeIndex = policyTrie.getGrantRevokeIndex();
        return grantRevokeIndex.hasPermissions(authorizationContext.getAuthorizationSubjectIds(), (Collection<String>)permissions);
    }

    @Override
    public boolean hasPartialPermissions(ResourceKey resourceKey, AuthorizationContext authorizationContext, Permissions permissions) {
        PolicyTrie policyTrie = TrieBasedPolicyEnforcer.seekWithFallback(resourceKey, this.bottomUpGrantTrie, this.inheritedTrie);
        GrantRevokeIndex grantRevokeIndex = policyTrie.getGrantRevokeIndex();
        return grantRevokeIndex.hasPermissions(authorizationContext.getAuthorizationSubjectIds(), (Collection<String>)permissions);
    }

    @Override
    public EffectedSubjectIds getSubjectIdsWithPermission(ResourceKey resourceKey, Permissions permissions) {
        TrieBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TrieBasedPolicyEnforcer.checkPermissions(permissions);
        return this.inheritedTrie.seekToLeastAncestor(PolicyTrie.getJsonKeyIterator(resourceKey)).getGrantRevokeIndex().getEffectedSubjectIds((Set<String>)permissions);
    }

    @Override
    public EffectedSubjects getSubjectsWithPermission(ResourceKey resourceKey, Permissions permissions) {
        TrieBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TrieBasedPolicyEnforcer.checkPermissions(permissions);
        return this.inheritedTrie.seekToLeastAncestor(PolicyTrie.getJsonKeyIterator(resourceKey)).getGrantRevokeIndex().getEffectedSubjects((Set<String>)permissions);
    }

    private static void checkResourceKey(ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"resource key");
    }

    private static void checkPermissions(Permissions permissions) {
        ConditionChecker.checkNotNull((Object)permissions, (String)"permissions to check");
    }

    @Override
    public Set<String> getSubjectIdsWithPartialPermission(ResourceKey resourceKey, Permissions permissions) {
        TrieBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TrieBasedPolicyEnforcer.checkPermissions(permissions);
        PolicyTrie policyTrie = TrieBasedPolicyEnforcer.seekWithFallback(resourceKey, this.bottomUpGrantTrie, this.inheritedTrie);
        GrantRevokeIndex grantRevokeIndex = policyTrie.getGrantRevokeIndex();
        return grantRevokeIndex.getGrantedSubjectIds((Set<String>)permissions);
    }

    @Override
    public Set<AuthorizationSubject> getSubjectsWithPartialPermission(ResourceKey resourceKey, Permissions permissions) {
        TrieBasedPolicyEnforcer.checkResourceKey(resourceKey);
        TrieBasedPolicyEnforcer.checkPermissions(permissions);
        PolicyTrie policyTrie = TrieBasedPolicyEnforcer.seekWithFallback(resourceKey, this.bottomUpGrantTrie, this.inheritedTrie);
        GrantRevokeIndex grantRevokeIndex = policyTrie.getGrantRevokeIndex();
        return grantRevokeIndex.getGrantedSubjects((Set<String>)permissions);
    }

    @Override
    public JsonObject buildJsonView(ResourceKey resourceKey, Iterable<JsonField> jsonFields, AuthorizationContext authorizationContext, Permissions permissions) {
        TrieBasedPolicyEnforcer.checkResourceKey(resourceKey);
        ConditionChecker.checkNotNull(jsonFields, (String)"JSON fields");
        TrieBasedPolicyEnforcer.checkPermissions(permissions);
        JsonKey typeKey = JsonKey.of((CharSequence)resourceKey.getResourceType());
        if (this.inheritedTrie.hasChild(typeKey)) {
            PolicyTrie start = this.inheritedTrie.seekToLeastAncestor(PolicyTrie.getJsonKeyIterator(resourceKey));
            return start.buildJsonView(jsonFields, authorizationContext.getAuthorizationSubjectIds(), permissions);
        }
        return JsonFactory.newObject();
    }

    private static PolicyTrie seekWithFallback(ResourceKey resourceKey, PolicyTrie firstTry, PolicyTrie fallback) {
        return firstTry.seekToExactNode(PolicyTrie.getJsonKeyIterator(resourceKey)).orElseGet(() -> fallback.seekToLeastAncestor(PolicyTrie.getJsonKeyIterator(resourceKey)));
    }
}

