/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.policies.PermissionEffect;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;

public interface EffectedPermissions
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static EffectedPermissions newInstance(@Nullable Iterable<String> grantedPermissions, @Nullable Iterable<String> revokedPermissions) {
        return PoliciesModelFactory.newEffectedPermissions(grantedPermissions, revokedPermissions);
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public Permissions getPermissions(PermissionEffect var1);

    default public Permissions getGrantedPermissions() {
        return this.getPermissions(PermissionEffect.GRANT);
    }

    default public Permissions getRevokedPermissions() {
        return this.getPermissions(PermissionEffect.REVOKE);
    }

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> GRANT = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"grant", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> REVOKE = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"revoke", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

