/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.PermissionEffect;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;

@Immutable
final class ImmutableEffectedPermissions
implements EffectedPermissions {
    private final Permissions grantedPermissions;
    private final Permissions revokedPermissions;

    private ImmutableEffectedPermissions(Permissions granted, Permissions revoked) {
        this.grantedPermissions = granted;
        this.revokedPermissions = revoked;
    }

    public static EffectedPermissions of(Iterable<String> grantedPermissions, Iterable<String> revokedPermissions) {
        Permissions granted = ImmutableEffectedPermissions.toPermissions(ImmutableEffectedPermissions.toSet((Iterable)ConditionChecker.checkNotNull(grantedPermissions, (String)"granted permissions")));
        Permissions revoked = ImmutableEffectedPermissions.toPermissions(ImmutableEffectedPermissions.toSet((Iterable)ConditionChecker.checkNotNull(revokedPermissions, (String)"revoked permissions")));
        return new ImmutableEffectedPermissions(granted, revoked);
    }

    private static Collection<String> toSet(Iterable<String> iterable) {
        HashSet<String> result;
        if (iterable instanceof Set) {
            result = (HashSet<String>)iterable;
        } else {
            result = new HashSet<String>();
            iterable.forEach(result::add);
        }
        return result;
    }

    private static Permissions toPermissions(Collection<String> stringCollection) {
        return stringCollection.isEmpty() ? PoliciesModelFactory.noPermissions() : PoliciesModelFactory.newPermissions(stringCollection);
    }

    public static EffectedPermissions fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        Set granted = (Set)DittoJsonException.wrapJsonRuntimeException(() -> ImmutableEffectedPermissions.getPermissionsFor(jsonObject, EffectedPermissions.JsonFields.GRANT));
        Set revoked = (Set)DittoJsonException.wrapJsonRuntimeException(() -> ImmutableEffectedPermissions.getPermissionsFor(jsonObject, EffectedPermissions.JsonFields.REVOKE));
        return ImmutableEffectedPermissions.of(granted, revoked);
    }

    private static Set<String> getPermissionsFor(JsonObject jsonObject, JsonFieldDefinition<JsonArray> effect) {
        return ((JsonArray)jsonObject.getValueOrThrow(effect)).stream().filter(JsonValue::isString).map(JsonValue::asString).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Permissions getPermissions(PermissionEffect effect) {
        switch ((PermissionEffect)((Object)ConditionChecker.checkNotNull((Object)((Object)effect), (String)"permission effect"))) {
            case GRANT: {
                return PoliciesModelFactory.newPermissions(this.grantedPermissions);
            }
            case REVOKE: {
                return PoliciesModelFactory.newPermissions(this.revokedPermissions);
            }
        }
        throw new IllegalArgumentException("Permission effect <" + (Object)((Object)effect) + "> is unknown!");
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().set(EffectedPermissions.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate).set(EffectedPermissions.JsonFields.GRANT, (Object)((JsonArray)this.grantedPermissions.toJson()), predicate).set(EffectedPermissions.JsonFields.REVOKE, (Object)((JsonArray)this.revokedPermissions.toJson()), predicate).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEffectedPermissions that = (ImmutableEffectedPermissions)o;
        return Objects.equals(this.grantedPermissions, that.grantedPermissions) && Objects.equals(this.revokedPermissions, that.revokedPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.grantedPermissions, this.revokedPermissions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [grantedPermissions=" + this.grantedPermissions + ", revokedPermissions=" + this.revokedPermissions + "]";
    }
}

