/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.validation.NoControlCharactersNoSlashesValidator;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PolicyEntryInvalidException;

@Immutable
final class ImmutableLabel
implements Label {
    private final String labelValue;

    private ImmutableLabel(String theLabelValue) {
        this.labelValue = theLabelValue;
    }

    public static Label of(CharSequence labelValue) {
        ConditionChecker.argumentNotEmpty((CharSequence)labelValue, (String)"label value");
        NoControlCharactersNoSlashesValidator validator = NoControlCharactersNoSlashesValidator.getInstance((CharSequence)labelValue);
        if (!validator.isValid()) {
            throw (PolicyEntryInvalidException)PolicyEntryInvalidException.newBuilder().message("The Policy Label " + labelValue + " is invalid").description((String)validator.getReason().orElse(null)).build();
        }
        return new ImmutableLabel(labelValue.toString());
    }

    @Override
    public int length() {
        return this.labelValue.length();
    }

    @Override
    public char charAt(int index) {
        return this.labelValue.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.labelValue.subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLabel that = (ImmutableLabel)o;
        return Objects.equals(this.labelValue, that.labelValue);
    }

    public int hashCode() {
        return Objects.hash(this.labelValue);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.labelValue;
    }
}

