/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonArrayBuilder;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.Permissions;

@Immutable
final class ImmutablePermissions
extends AbstractSet<String>
implements Permissions {
    private final Set<String> permissions;

    private ImmutablePermissions(Set<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions");
        this.permissions = Collections.unmodifiableSet(new HashSet<String>(permissions));
    }

    public static Permissions none() {
        return new ImmutablePermissions(Collections.emptySet());
    }

    public static Permissions of(String permission, String ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)permission, (String)"permission");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions");
        HashSet<String> permissions = new HashSet<String>(1 + furtherPermissions.length);
        permissions.add(permission);
        Collections.addAll(permissions, furtherPermissions);
        return new ImmutablePermissions(permissions);
    }

    public static Permissions of(Collection<String> permissions) {
        ConditionChecker.checkNotNull(permissions, (String)"permissions");
        HashSet<String> permissionSet = new HashSet<String>();
        if (!permissions.isEmpty()) {
            permissionSet.addAll(permissions);
        }
        return new ImmutablePermissions(permissionSet);
    }

    @Override
    public boolean contains(String permission, String ... furtherPermissions) {
        ConditionChecker.checkNotNull((Object)permission, (String)"permission whose presence is to be checked");
        ConditionChecker.checkNotNull((Object)furtherPermissions, (String)"further permissions whose presence are to be checked");
        HashSet<String> permissionSet = new HashSet<String>();
        permissionSet.add(permission);
        permissionSet.addAll(Arrays.asList(furtherPermissions));
        return this.permissions.containsAll(permissionSet);
    }

    @Override
    public boolean contains(Permissions permissions) {
        ConditionChecker.checkNotNull((Object)permissions, (String)"permissions whose presence is to be checked");
        return this.permissions.containsAll(permissions);
    }

    @Override
    public int size() {
        return this.permissions.size();
    }

    public JsonArray toJson() {
        JsonArrayBuilder jsonArrayBuilder = JsonFactory.newArrayBuilder();
        this.permissions.forEach(x$0 -> jsonArrayBuilder.add(x$0, new String[0]));
        return jsonArrayBuilder.build();
    }

    @Override
    @Nonnull
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final Iterator<String> i;
            {
                this.i = ImmutablePermissions.this.permissions.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public String next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super String> action) {
                this.i.forEachRemaining(action);
            }
        };
    }

    @Override
    public boolean add(String e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends String> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super String> filter) {
        throw new UnsupportedOperationException();
    }
}

