/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.metadata.Metadata;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.ImmutablePolicyEntry;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.policies.PolicyLifecycle;
import org.eclipse.ditto.model.policies.PolicyRevision;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.Subjects;

@Immutable
final class ImmutablePolicy
implements Policy {
    @Nullable
    private final PolicyId policyId;
    private final Map<Label, PolicyEntry> entries;
    @Nullable
    private final String namespace;
    @Nullable
    private final PolicyLifecycle lifecycle;
    @Nullable
    private final PolicyRevision revision;
    @Nullable
    private final Instant modified;
    @Nullable
    private final Instant created;

    private ImmutablePolicy(@Nullable PolicyId policyId, Map<Label, PolicyEntry> theEntries, @Nullable PolicyLifecycle lifecycle, @Nullable PolicyRevision revision, @Nullable Instant modified, @Nullable Instant created) {
        this.policyId = policyId;
        this.entries = Collections.unmodifiableMap(new LinkedHashMap<Label, PolicyEntry>(theEntries));
        this.namespace = policyId == null ? null : policyId.getNamespace();
        this.lifecycle = lifecycle;
        this.revision = revision;
        this.modified = modified;
        this.created = created;
    }

    @Deprecated
    public static Policy of(@Nullable String policyId, @Nullable PolicyLifecycle lifecycle, @Nullable PolicyRevision revision, @Nullable Instant modified, @Nullable Instant created, Iterable<PolicyEntry> entries) {
        return ImmutablePolicy.of(PolicyId.of(policyId), lifecycle, revision, modified, created, entries);
    }

    public static Policy of(@Nullable PolicyId policyId, @Nullable PolicyLifecycle lifecycle, @Nullable PolicyRevision revision, @Nullable Instant modified, @Nullable Instant created, Iterable<PolicyEntry> entries) {
        ConditionChecker.checkNotNull(entries, (String)"Policy entries");
        LinkedHashMap<Label, PolicyEntry> entryMap = new LinkedHashMap<Label, PolicyEntry>();
        entries.forEach(policyEntry -> entryMap.put(policyEntry.getLabel(), (PolicyEntry)policyEntry));
        return new ImmutablePolicy(policyId, entryMap, lifecycle, revision, modified, created);
    }

    public static Policy fromJson(JsonObject jsonObject) {
        PolicyId policyId = jsonObject.getValue(Policy.JsonFields.ID).map(PolicyId::of).orElse(null);
        PolicyLifecycle readLifecycle = jsonObject.getValue(Policy.JsonFields.LIFECYCLE).flatMap(PolicyLifecycle::forName).orElse(null);
        PolicyRevision readRevision = jsonObject.getValue(Policy.JsonFields.REVISION).map(PolicyRevision::newInstance).orElse(null);
        Instant readModified = jsonObject.getValue(Policy.JsonFields.MODIFIED).map(ImmutablePolicy::tryToParseModified).orElse(null);
        Instant readCreated = jsonObject.getValue(Policy.JsonFields.CREATED).map(ImmutablePolicy::tryToParseModified).orElse(null);
        JsonObject readEntries = (JsonObject)jsonObject.getValueOrThrow(Policy.JsonFields.ENTRIES);
        Function<JsonField, PolicyEntry> toPolicyEntry = jsonField -> {
            JsonValue jsonValue = jsonField.getValue();
            if (!jsonValue.isObject()) {
                throw new DittoJsonException((RuntimeException)JsonParseException.newBuilder().message(MessageFormat.format("<{0}> is not a JSON object!", jsonValue)).build());
            }
            return ImmutablePolicyEntry.fromJson((CharSequence)jsonField.getKey(), jsonValue.asObject());
        };
        Collection policyEntries = readEntries.stream().filter(jsonField -> !Objects.equals(jsonField.getKey(), JsonSchemaVersion.getJsonKey())).map(toPolicyEntry).collect(Collectors.toCollection(LinkedHashSet::new));
        return ImmutablePolicy.of(policyId, readLifecycle, readRevision, readModified, readCreated, (Iterable<PolicyEntry>)policyEntries);
    }

    private static Instant tryToParseModified(CharSequence dateTime) {
        try {
            return Instant.parse(dateTime);
        }
        catch (DateTimeParseException e) {
            throw new JsonParseException("The JSON object's field '" + Policy.JsonFields.MODIFIED.getPointer() + "' is not in ISO-8601 format as expected");
        }
    }

    @Override
    public Optional<PolicyId> getEntityId() {
        return Optional.ofNullable(this.policyId);
    }

    @Override
    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    @Override
    public Optional<PolicyLifecycle> getLifecycle() {
        return Optional.ofNullable(this.lifecycle);
    }

    public Optional<PolicyRevision> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public Optional<Instant> getModified() {
        return Optional.ofNullable(this.modified);
    }

    public Optional<Instant> getCreated() {
        return Optional.ofNullable(this.created);
    }

    public Optional<Metadata> getMetadata() {
        return Optional.empty();
    }

    public boolean isDeleted() {
        return PolicyLifecycle.DELETED.equals((Object)this.lifecycle);
    }

    @Override
    public Policy setEntry(PolicyEntry policyEntry) {
        ImmutablePolicy result;
        ConditionChecker.checkNotNull((Object)policyEntry, (String)"entry to be set to this Policy");
        PolicyEntry existingPolicyEntry = this.entries.get(policyEntry.getLabel());
        if (null != existingPolicyEntry) {
            if (existingPolicyEntry.equals(policyEntry)) {
                result = this;
            } else {
                Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
                entriesCopy.put(policyEntry.getLabel(), policyEntry);
                result = new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
            }
        } else {
            Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
            entriesCopy.put(policyEntry.getLabel(), policyEntry);
            result = new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
        }
        return result;
    }

    @Override
    public Set<Label> getLabels() {
        return this.entries.keySet();
    }

    @Override
    public boolean contains(CharSequence label) {
        return this.entries.containsKey(Label.of(label));
    }

    @Override
    public Optional<PolicyEntry> getEntryFor(CharSequence label) {
        return Optional.ofNullable(this.entries.get(Label.of(label)));
    }

    @Override
    public Policy removeEntry(CharSequence label) {
        Label lbl = Label.of(label);
        if (!this.entries.containsKey(lbl)) {
            return this;
        }
        Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
        entriesCopy.remove(lbl);
        return new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
    }

    @Override
    public Policy removeEntry(PolicyEntry entry) {
        ConditionChecker.checkNotNull((Object)entry, (String)"Policy entry to be removed");
        return this.removeEntry(entry.getLabel());
    }

    @Override
    public Policy setSubjectsFor(CharSequence label, Subjects subjects) {
        PolicyEntry modifiedEntry;
        Label lbl = Label.of(label);
        ConditionChecker.checkNotNull((Object)subjects, (String)"subjects to set to the Policy entry");
        Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
        if (!entriesCopy.containsKey(lbl)) {
            modifiedEntry = PoliciesModelFactory.newPolicyEntry(lbl, subjects, PoliciesModelFactory.emptyResources());
        } else {
            PolicyEntry policyEntry = entriesCopy.get(lbl);
            modifiedEntry = PoliciesModelFactory.newPolicyEntry(lbl, subjects, policyEntry.getResources());
        }
        entriesCopy.put(lbl, modifiedEntry);
        return new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
    }

    @Override
    public Policy setSubjectFor(CharSequence label, Subject subject) {
        Policy result;
        Label lbl = Label.of(label);
        ConditionChecker.checkNotNull((Object)subject, (String)"subject to set to the Policy entry");
        PolicyEntry existingPolicyEntry = this.entries.get(lbl);
        if (null != existingPolicyEntry) {
            Subjects newSubjects;
            Subjects existingSubjects = existingPolicyEntry.getSubjects();
            if (!Objects.equals(existingSubjects, newSubjects = existingSubjects.setSubject(subject))) {
                Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
                entriesCopy.put(lbl, PoliciesModelFactory.newPolicyEntry(lbl, newSubjects, existingPolicyEntry.getResources()));
                result = new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
            } else {
                result = this;
            }
        } else {
            result = this.setSubjectsFor(label, Subjects.newInstance(subject, new Subject[0]));
        }
        return result;
    }

    @Override
    public Policy removeSubjectFor(CharSequence label, SubjectId subjectId) {
        Subjects newSubjects;
        Subjects existingSubjects;
        Label lbl = Label.of(label);
        ImmutablePolicy result = this;
        PolicyEntry existingPolicyEntry = this.entries.get(lbl);
        if (null != existingPolicyEntry && !Objects.equals(existingSubjects = existingPolicyEntry.getSubjects(), newSubjects = existingSubjects.removeSubject(subjectId))) {
            Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
            entriesCopy.put(lbl, PoliciesModelFactory.newPolicyEntry(lbl, newSubjects, existingPolicyEntry.getResources()));
            result = new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
        }
        return result;
    }

    @Override
    public Policy setResourcesFor(CharSequence label, Resources resources) {
        Label lbl = Label.of(label);
        ConditionChecker.checkNotNull((Object)resources, (String)"resources to set to the Policy entry");
        Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
        PolicyEntry policyEntry = entriesCopy.get(lbl);
        PolicyEntry modifiedEntry = null == policyEntry ? PoliciesModelFactory.newPolicyEntry(lbl, PoliciesModelFactory.emptySubjects(), resources) : PoliciesModelFactory.newPolicyEntry(lbl, policyEntry.getSubjects(), resources);
        entriesCopy.put(lbl, modifiedEntry);
        return new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
    }

    @Override
    public Policy setResourceFor(CharSequence label, Resource resource) {
        PolicyEntry modifiedEntry;
        Label lbl = Label.of(label);
        ConditionChecker.checkNotNull((Object)resource, (String)"resource to set to the Policy entry");
        Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
        if (!entriesCopy.containsKey(lbl)) {
            modifiedEntry = PoliciesModelFactory.newPolicyEntry(label, PoliciesModelFactory.emptySubjects(), PoliciesModelFactory.newResources(resource, new Resource[0]));
        } else {
            PolicyEntry policyEntry = entriesCopy.get(lbl);
            Resources modifiedResources = policyEntry.getResources().setResource(resource);
            modifiedEntry = PoliciesModelFactory.newPolicyEntry(label, policyEntry.getSubjects(), modifiedResources);
        }
        entriesCopy.put(lbl, modifiedEntry);
        return new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
    }

    @Override
    public Policy removeResourceFor(CharSequence label, ResourceKey resourceKey) {
        Resources newResources;
        Resources existingResources;
        Label lbl = Label.of(label);
        ImmutablePolicy result = this;
        PolicyEntry existingEntry = this.entries.get(lbl);
        if (null != existingEntry && !Objects.equals(existingResources = existingEntry.getResources(), newResources = existingResources.removeResource(resourceKey))) {
            Map<Label, PolicyEntry> entriesCopy = this.copyEntries();
            entriesCopy.put(lbl, PoliciesModelFactory.newPolicyEntry(lbl, existingEntry.getSubjects(), newResources));
            result = new ImmutablePolicy(this.policyId, entriesCopy, this.lifecycle, this.revision, this.modified, this.created);
        }
        return result;
    }

    @Override
    public Optional<EffectedPermissions> getEffectedPermissionsFor(CharSequence label, SubjectId subjectId, ResourceKey resourceKey) {
        Subjects subjects;
        Optional<Subject> subjectOptional;
        Label lbl = Label.of(label);
        Optional<EffectedPermissions> result = Optional.empty();
        PolicyEntry policyEntry = this.entries.get(lbl);
        if (null != policyEntry && (subjectOptional = (subjects = policyEntry.getSubjects()).getSubject(subjectId)).isPresent()) {
            Resources resources = policyEntry.getResources();
            result = resources.getResource(resourceKey).map(Resource::getEffectedPermissions);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public Set<PolicyEntry> getEntriesSet() {
        return this.stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Stream<PolicyEntry> stream() {
        return this.entries.values().stream();
    }

    @Override
    public Iterator<PolicyEntry> iterator() {
        Set<PolicyEntry> policyEntries = this.getEntriesSet();
        return policyEntries.iterator();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        ConditionChecker.checkNotNull((Object)schemaVersion, (String)"schema version");
        ConditionChecker.checkNotNull(thePredicate, (String)"predicate");
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Policy.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        if (null != this.lifecycle) {
            jsonObjectBuilder.set(Policy.JsonFields.LIFECYCLE, (Object)this.lifecycle.name(), predicate);
        }
        if (null != this.revision) {
            jsonObjectBuilder.set(Policy.JsonFields.REVISION, (Object)this.revision.toLong(), predicate);
        }
        if (null != this.modified) {
            jsonObjectBuilder.set(Policy.JsonFields.MODIFIED, (Object)this.modified.toString(), predicate);
        }
        if (null != this.created) {
            jsonObjectBuilder.set(Policy.JsonFields.CREATED, (Object)this.created.toString(), predicate);
        }
        if (null != this.policyId) {
            jsonObjectBuilder.set(Policy.JsonFields.NAMESPACE, (Object)this.namespace, predicate);
            jsonObjectBuilder.set(Policy.JsonFields.ID, (Object)String.valueOf((Object)this.policyId), predicate);
        }
        jsonObjectBuilder.set(Policy.JsonFields.ENTRIES, (Object)((JsonObject)this.stream().map(policyEntry -> JsonFactory.newObjectBuilder().set(policyEntry.getLabel().getJsonFieldDefinition(), (Object)((JsonObject)policyEntry.toJson(schemaVersion, thePredicate.and(FieldType.notHidden()))), predicate).build()).collect(JsonCollectors.objectsToObject())), predicate);
        return jsonObjectBuilder.build();
    }

    private Map<Label, PolicyEntry> copyEntries() {
        return new LinkedHashMap<Label, PolicyEntry>(this.entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePolicy that = (ImmutablePolicy)o;
        return Objects.equals((Object)this.policyId, (Object)that.policyId) && Objects.equals(this.namespace, that.namespace) && this.lifecycle == that.lifecycle && Objects.equals(this.revision, that.revision) && Objects.equals(this.modified, that.modified) && Objects.equals(this.created, that.created) && Objects.equals(this.entries, that.entries);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policyId, this.namespace, this.lifecycle, this.revision, this.modified, this.created, this.entries});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [policyId=" + (Object)((Object)this.policyId) + ", namespace=" + this.namespace + ", lifecycle=" + (Object)((Object)this.lifecycle) + ", revision=" + this.revision + ", modified=" + this.modified + ", created=" + this.created + ", entries=" + this.entries + "]";
    }
}

