/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.ImmutablePolicy;
import org.eclipse.ditto.model.policies.ImmutablePolicyBuilderLabelScoped;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyBuilder;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.policies.PolicyLifecycle;
import org.eclipse.ditto.model.policies.PolicyRevision;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.Subjects;

@NotThreadSafe
final class ImmutablePolicyBuilder
implements PolicyBuilder {
    private final Map<Label, Map<SubjectId, Subject>> subjects = new LinkedHashMap<Label, Map<SubjectId, Subject>>();
    private final Map<Label, Map<ResourceKey, Permissions>> grantedPermissions = new LinkedHashMap<Label, Map<ResourceKey, Permissions>>();
    private final Map<Label, Map<ResourceKey, Permissions>> revokedPermissions = new LinkedHashMap<Label, Map<ResourceKey, Permissions>>();
    @Nullable
    private PolicyId id = null;
    @Nullable
    private PolicyLifecycle lifecycle = null;
    @Nullable
    private PolicyRevision revision = null;
    @Nullable
    private Instant modified = null;
    @Nullable
    private Instant created = null;

    private ImmutablePolicyBuilder() {
    }

    public static ImmutablePolicyBuilder newInstance() {
        return new ImmutablePolicyBuilder();
    }

    public static ImmutablePolicyBuilder of(PolicyId id) {
        return new ImmutablePolicyBuilder().setId(id);
    }

    public static PolicyBuilder of(PolicyId id, Iterable<PolicyEntry> policyEntries) {
        ConditionChecker.checkNotNull(policyEntries, (String)"initial Policy entries");
        ImmutablePolicyBuilder result = new ImmutablePolicyBuilder();
        result.setId(id);
        policyEntries.forEach(result::set);
        return result;
    }

    public static PolicyBuilder of(Policy existingPolicy) {
        ConditionChecker.checkNotNull((Object)existingPolicy, (String)"existing Policy");
        ImmutablePolicyBuilder result = new ImmutablePolicyBuilder().setLifecycle(existingPolicy.getLifecycle().orElse(null)).setRevision(existingPolicy.getRevision().orElse(null)).setModified(existingPolicy.getModified().orElse(null));
        existingPolicy.getEntityId().ifPresent(result::setId);
        existingPolicy.forEach(result::set);
        return result;
    }

    @Override
    public PolicyBuilder.LabelScoped forLabel(Label label) {
        return ImmutablePolicyBuilderLabelScoped.newInstance(this, label);
    }

    @Override
    @Deprecated
    public ImmutablePolicyBuilder setId(CharSequence id) {
        return this.setId(PolicyId.of(id));
    }

    @Override
    public ImmutablePolicyBuilder setId(PolicyId id) {
        this.id = (PolicyId)((Object)ConditionChecker.checkNotNull((Object)((Object)id), (String)"Policy ID"));
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setLifecycle(@Nullable PolicyLifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setRevision(@Nullable PolicyRevision revision) {
        this.revision = revision;
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setModified(@Nullable Instant modified) {
        this.modified = modified;
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setCreated(@Nullable Instant created) {
        this.created = created;
        return this;
    }

    @Override
    public ImmutablePolicyBuilder set(PolicyEntry entry) {
        this.setPolicyEntry((PolicyEntry)ConditionChecker.checkNotNull((Object)entry, (String)"entry to be set"));
        return this;
    }

    private void setPolicyEntry(PolicyEntry entry) {
        this.putAllSubjects(entry);
        Label label = entry.getLabel();
        this.grantedPermissions.put(label, new LinkedHashMap());
        this.revokedPermissions.put(label, new LinkedHashMap());
        this.setResourcesFor(entry.getLabel(), entry.getResources());
    }

    private void putAllSubjects(PolicyEntry policyEntry) {
        Subjects entrySubjects = policyEntry.getSubjects();
        LinkedHashMap subjectsMap = new LinkedHashMap(entrySubjects.getSize());
        entrySubjects.forEach(entrySubject -> subjectsMap.put(entrySubject.getId(), entrySubject));
        this.subjects.put(policyEntry.getLabel(), subjectsMap);
    }

    @Override
    public ImmutablePolicyBuilder setAll(Iterable<PolicyEntry> entries) {
        ConditionChecker.checkNotNull(entries, (String)"entries to be set");
        entries.forEach(this::setPolicyEntry);
        return this;
    }

    @Override
    public ImmutablePolicyBuilder remove(CharSequence label) {
        ConditionChecker.checkNotNull((Object)label, (String)"label of the entry to be removed");
        this.removePolicyEntryFor(Label.of(label));
        return this;
    }

    private void removePolicyEntryFor(Label label) {
        this.subjects.remove(label);
        this.grantedPermissions.remove(label);
        this.revokedPermissions.remove(label);
    }

    @Override
    public ImmutablePolicyBuilder removeAll(Iterable<PolicyEntry> entries) {
        ConditionChecker.checkNotNull(entries, (String)"entries to be removed");
        entries.forEach(this::remove);
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setSubjectsFor(CharSequence label, Subjects subjects) {
        ConditionChecker.checkNotNull((Object)subjects, (String)"Subjects to be set");
        Map<SubjectId, Subject> existingSubject = this.retrieveExistingSubjects(label);
        subjects.forEach(subject -> existingSubject.put(subject.getId(), (Subject)subject));
        return this;
    }

    private Map<SubjectId, Subject> retrieveExistingSubjects(CharSequence label) {
        return this.subjects.computeIfAbsent(Label.of(label), l -> new LinkedHashMap());
    }

    @Override
    public ImmutablePolicyBuilder setSubjectFor(CharSequence label, Subject subject) {
        ConditionChecker.checkNotNull((Object)subject, (String)"Subject to be set");
        Map<SubjectId, Subject> existingSubject = this.retrieveExistingSubjects(label);
        existingSubject.put(subject.getId(), subject);
        return this;
    }

    @Override
    public ImmutablePolicyBuilder removeSubjectFor(CharSequence label, CharSequence subjectIssuerWithId) {
        Map<SubjectId, Subject> existingSubject = this.retrieveExistingSubjects(label);
        existingSubject.remove(SubjectId.newInstance(subjectIssuerWithId));
        return this;
    }

    @Override
    public ImmutablePolicyBuilder removeSubjectFor(CharSequence label, Subject subject) {
        ConditionChecker.checkNotNull((Object)subject, (String)"Subject");
        Map<SubjectId, Subject> existingSubject = this.retrieveExistingSubjects(label);
        existingSubject.remove(subject.getId());
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setResourcesFor(CharSequence label, Resources resources) {
        ConditionChecker.checkNotNull((Object)resources, (String)"Resources to be set");
        Map<ResourceKey, Permissions> grantedMap = this.retrieveGrantedPermissions(label);
        Map<ResourceKey, Permissions> revokedMap = this.retrieveRevokedPermissions(label);
        resources.forEach(resource -> {
            ResourceKey resourceKey = resource.getResourceKey();
            EffectedPermissions effectedPermissions = resource.getEffectedPermissions();
            grantedMap.put(resourceKey, effectedPermissions.getGrantedPermissions());
            revokedMap.put(resourceKey, effectedPermissions.getRevokedPermissions());
        });
        return this;
    }

    private Map<ResourceKey, Permissions> retrieveGrantedPermissions(CharSequence label) {
        return ImmutablePolicyBuilder.getPermissions(label, this.grantedPermissions);
    }

    private static Map<ResourceKey, Permissions> getPermissions(CharSequence l, Map<Label, Map<ResourceKey, Permissions>> permissionsMap) {
        return permissionsMap.computeIfAbsent(Label.of(l), k -> new LinkedHashMap());
    }

    private Map<ResourceKey, Permissions> retrieveRevokedPermissions(CharSequence label) {
        return ImmutablePolicyBuilder.getPermissions(label, this.revokedPermissions);
    }

    @Override
    public ImmutablePolicyBuilder setResourceFor(CharSequence label, Resource resource) {
        return this.setResourcesFor(label, Resources.newInstance(resource, new Resource[0]));
    }

    @Override
    public ImmutablePolicyBuilder removeResourceFor(CharSequence label, ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"key of the resource to be removed");
        this.retrieveGrantedPermissions(label).remove(resourceKey);
        this.retrieveRevokedPermissions(label).remove(resourceKey);
        return this;
    }

    @Override
    public ImmutablePolicyBuilder removeResourceFor(CharSequence label, Resource resource) {
        ConditionChecker.checkNotNull((Object)resource, (String)"the resource to be removed");
        return this.removeResourceFor(label, resource.getResourceKey());
    }

    @Override
    public ImmutablePolicyBuilder setPermissionsFor(CharSequence label, ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
        ImmutablePolicyBuilder.checkResourceKey(resourceKey);
        ConditionChecker.checkNotNull((Object)effectedPermissions, (String)"permissions to be set");
        this.retrieveGrantedPermissions(label).put(resourceKey, effectedPermissions.getGrantedPermissions());
        this.retrieveRevokedPermissions(label).put(resourceKey, effectedPermissions.getRevokedPermissions());
        return this;
    }

    private static void checkResourceKey(ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"resource key");
    }

    @Override
    public ImmutablePolicyBuilder setGrantedPermissionsFor(CharSequence label, ResourceKey resourceKey, Permissions grantedPermissions) {
        ImmutablePolicyBuilder.checkResourceKey(resourceKey);
        ConditionChecker.checkNotNull(this.revokedPermissions, (String)"granted permissions");
        this.retrieveGrantedPermissions(label).put(resourceKey, grantedPermissions);
        return this;
    }

    @Override
    public ImmutablePolicyBuilder setRevokedPermissionsFor(CharSequence label, ResourceKey resourceKey, Permissions revokedPermissions) {
        ImmutablePolicyBuilder.checkResourceKey(resourceKey);
        ConditionChecker.checkNotNull((Object)revokedPermissions, (String)"revoked permissions");
        this.retrieveRevokedPermissions(label).put(resourceKey, revokedPermissions);
        return this;
    }

    @Override
    public Policy build() {
        Collection<Label> allLabels = this.getAllLabels();
        Collection policyEntries = allLabels.stream().map(lbl -> PoliciesModelFactory.newPolicyEntry(lbl, this.getFinalSubjects((CharSequence)lbl), this.getFinalResources((CharSequence)lbl))).collect(Collectors.toList());
        return ImmutablePolicy.of(this.id, this.lifecycle, this.revision, this.modified, this.created, (Iterable<PolicyEntry>)policyEntries);
    }

    @Nonnull
    private Collection<Label> getAllLabels() {
        LinkedHashSet<Label> result = new LinkedHashSet<Label>(this.subjects.keySet());
        result.addAll(this.grantedPermissions.keySet());
        result.addAll(this.revokedPermissions.keySet());
        return result;
    }

    @Nonnull
    private Subjects getFinalSubjects(CharSequence label) {
        return PoliciesModelFactory.newSubjects(this.retrieveExistingSubjects(label).values());
    }

    @Nonnull
    private Resources getFinalResources(CharSequence label) {
        Map<ResourceKey, Permissions> grantedMap = this.retrieveGrantedPermissions(label);
        Map<ResourceKey, Permissions> revokedMap = this.retrieveRevokedPermissions(label);
        LinkedHashSet<ResourceKey> allResourceKeys = new LinkedHashSet<ResourceKey>(grantedMap.keySet());
        allResourceKeys.addAll(revokedMap.keySet());
        Collection resourcesList = allResourceKeys.stream().map(resourceKey -> {
            Permissions granted = (Permissions)grantedMap.get(resourceKey);
            Permissions revoked = (Permissions)revokedMap.get(resourceKey);
            EffectedPermissions ep = PoliciesModelFactory.newEffectedPermissions(granted, revoked);
            return PoliciesModelFactory.newResource(resourceKey, ep);
        }).collect(Collectors.toList());
        return PoliciesModelFactory.newResources(resourcesList);
    }
}

