/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.time.Instant;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyBuilder;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.policies.PolicyLifecycle;
import org.eclipse.ditto.model.policies.PolicyRevision;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.Subjects;

@NotThreadSafe
final class ImmutablePolicyBuilderLabelScoped
implements PolicyBuilder.LabelScoped {
    private final PolicyBuilder delegate;
    private final Label label;

    private ImmutablePolicyBuilderLabelScoped(PolicyBuilder delegate, Label label) {
        this.delegate = delegate;
        this.label = label;
    }

    public static PolicyBuilder.LabelScoped newInstance(PolicyBuilder delegate, Label label) {
        return new ImmutablePolicyBuilderLabelScoped((PolicyBuilder)ConditionChecker.checkNotNull((Object)delegate, (String)"delegate"), (Label)ConditionChecker.checkNotNull((Object)label, (String)"label"));
    }

    @Override
    public PolicyBuilder.LabelScoped forLabel(Label label) {
        return ImmutablePolicyBuilderLabelScoped.newInstance(this.delegate, label);
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public PolicyBuilder exitLabel() {
        return this.delegate;
    }

    @Override
    @Deprecated
    public ImmutablePolicyBuilderLabelScoped setId(@Nullable CharSequence id) {
        return this.setId(PolicyId.of(id));
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setId(@Nullable PolicyId id) {
        this.delegate.setId(id);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setLifecycle(@Nullable PolicyLifecycle lifecycle) {
        this.delegate.setLifecycle(lifecycle);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setRevision(@Nullable PolicyRevision revision) {
        this.delegate.setRevision(revision);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setModified(@Nullable Instant modified) {
        this.delegate.setModified(modified);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setCreated(@Nullable Instant created) {
        this.delegate.setCreated(created);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped set(PolicyEntry entry) {
        this.delegate.set(entry);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setAll(Iterable<PolicyEntry> entries) {
        this.delegate.setAll(entries);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped remove(CharSequence label) {
        this.delegate.remove(label);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped remove(PolicyEntry entry) {
        this.delegate.remove(entry);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped removeAll(Iterable<PolicyEntry> entries) {
        this.delegate.removeAll(entries);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setSubjectsFor(CharSequence label, Subjects subjects) {
        this.delegate.setSubjectsFor(label, subjects);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setSubjectFor(CharSequence label, Subject subject) {
        this.delegate.setSubjectFor(label, subject);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped removeSubjectFor(CharSequence label, CharSequence subjectId) {
        this.delegate.removeSubjectFor(label, subjectId);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped removeSubjectFor(CharSequence label, Subject subject) {
        this.delegate.removeSubjectFor(label, subject);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setResourcesFor(CharSequence label, Resources resources) {
        this.delegate.setResourcesFor(label, resources);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setResourceFor(CharSequence label, Resource resource) {
        this.delegate.setResourceFor(label, resource);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped removeResourceFor(CharSequence label, ResourceKey resourceKey) {
        this.delegate.removeResourceFor(label, resourceKey);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped removeResourceFor(CharSequence label, Resource resource) {
        this.delegate.removeResourceFor(label, resource);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setPermissionsFor(CharSequence label, ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
        this.delegate.setPermissionsFor(label, resourceKey, effectedPermissions);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setGrantedPermissionsFor(CharSequence label, ResourceKey resourceKey, Permissions grantedPermissions) {
        this.delegate.setGrantedPermissionsFor(label, resourceKey, grantedPermissions);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setGrantedPermissionsFor(CharSequence label, ResourceKey resourceKey, String grantedPermission, String ... furtherGrantedPermissions) {
        this.delegate.setGrantedPermissionsFor(label, resourceKey, grantedPermission, furtherGrantedPermissions);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setRevokedPermissionsFor(CharSequence label, ResourceKey resourceKey, Permissions revokedPermissions) {
        this.delegate.setRevokedPermissionsFor(label, resourceKey, revokedPermissions);
        return this;
    }

    @Override
    public ImmutablePolicyBuilderLabelScoped setRevokedPermissionsFor(CharSequence label, ResourceKey resourceKey, String revokedPermission, String ... furtherRevokedPermissions) {
        this.delegate.setRevokedPermissionsFor(label, resourceKey, revokedPermission, furtherRevokedPermissions);
        return this;
    }

    @Override
    public Policy build() {
        return this.delegate.build();
    }
}

