/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subjects;

@Immutable
final class ImmutablePolicyEntry
implements PolicyEntry {
    private final Label label;
    private final Subjects subjects;
    private final Resources resources;

    private ImmutablePolicyEntry(Label theLabel, Subjects theSubjects, Resources theResources) {
        this.label = (Label)ConditionChecker.checkNotNull((Object)theLabel, (String)"label");
        this.subjects = theSubjects;
        this.resources = theResources;
    }

    public static PolicyEntry of(Label label, Subjects subjects, Resources resources) {
        ConditionChecker.checkNotNull((Object)subjects, (String)"subjects");
        ConditionChecker.checkNotNull((Object)resources, (String)"resources");
        return new ImmutablePolicyEntry(label, subjects, resources);
    }

    public static PolicyEntry fromJson(CharSequence label, JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        Label lbl = Label.of(label);
        try {
            JsonObject subjectsJsonObject = (JsonObject)jsonObject.getValueOrThrow(PolicyEntry.JsonFields.SUBJECTS);
            Subjects subjectsFromJson = PoliciesModelFactory.newSubjects(subjectsJsonObject);
            JsonObject resourcesJsonObject = (JsonObject)jsonObject.getValueOrThrow(PolicyEntry.JsonFields.RESOURCES);
            Resources resourcesFromJson = PoliciesModelFactory.newResources(resourcesJsonObject);
            return ImmutablePolicyEntry.of(lbl, subjectsFromJson, resourcesFromJson);
        }
        catch (JsonMissingFieldException e) {
            throw new DittoJsonException((RuntimeException)((Object)e));
        }
    }

    @Override
    public Label getLabel() {
        return this.label;
    }

    @Override
    public Subjects getSubjects() {
        return this.subjects;
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().set(PolicyEntry.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate).set(PolicyEntry.JsonFields.SUBJECTS, (Object)((JsonObject)this.subjects.toJson(schemaVersion, thePredicate)), predicate).set(PolicyEntry.JsonFields.RESOURCES, (Object)((JsonObject)this.resources.toJson(schemaVersion, thePredicate)), predicate).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePolicyEntry that = (ImmutablePolicyEntry)o;
        return Objects.equals(this.label, that.label) && Objects.equals(this.subjects, that.subjects) && Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.subjects, this.resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [label=" + this.label + ", subjects=" + this.subjects + ", resources=" + this.resources + "]";
    }
}

