/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.PolicyRevision;

@Immutable
final class ImmutablePolicyRevision
implements PolicyRevision {
    private final long value;

    private ImmutablePolicyRevision(long theValue) {
        this.value = theValue;
    }

    public static ImmutablePolicyRevision of(long value) {
        return new ImmutablePolicyRevision(value);
    }

    public boolean isGreaterThan(PolicyRevision other) {
        return 0 < this.compareTo(other);
    }

    public boolean isGreaterThanOrEqualTo(PolicyRevision other) {
        return 0 <= this.compareTo(other);
    }

    public boolean isLowerThan(PolicyRevision other) {
        return 0 > this.compareTo(other);
    }

    public boolean isLowerThanOrEqualTo(PolicyRevision other) {
        return 0 >= this.compareTo(other);
    }

    public PolicyRevision increment() {
        return ImmutablePolicyRevision.of(this.value + 1L);
    }

    public long toLong() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePolicyRevision that = (ImmutablePolicyRevision)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public int compareTo(PolicyRevision o) {
        ConditionChecker.checkNotNull((Object)o, (String)"other revision to compare this revision with");
        return Long.compare(this.value, o.toLong());
    }
}

