/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.ImmutableEffectedPermissions;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;

@Immutable
final class ImmutableResource
implements Resource {
    private final ResourceKey resourceKey;
    private final EffectedPermissions effectedPermissions;

    private ImmutableResource(ResourceKey theResourceKey, EffectedPermissions theEffectedPermissions) {
        this.resourceKey = (ResourceKey)ConditionChecker.checkNotNull((Object)theResourceKey, (String)"Resource key");
        this.effectedPermissions = (EffectedPermissions)ConditionChecker.checkNotNull((Object)theEffectedPermissions, (String)"effected permissions");
    }

    public static Resource of(ResourceKey resourceKey, JsonValue jsonValue) {
        ConditionChecker.checkNotNull((Object)jsonValue, (String)"JSON value");
        EffectedPermissions effectedPermissions = Optional.of(jsonValue).filter(JsonValue::isObject).map(JsonValue::asObject).map(object -> (EffectedPermissions)DittoJsonException.wrapJsonRuntimeException(() -> ImmutableEffectedPermissions.fromJson(object))).orElseThrow(() -> new DittoJsonException((RuntimeException)JsonParseException.newBuilder().message("The JSON object for the 'permissions' (grant/revoke) of the 'resource' '" + resourceKey + "' is missing or not an object.").build()));
        return ImmutableResource.of(resourceKey, effectedPermissions);
    }

    public static Resource of(ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
        return new ImmutableResource(resourceKey, effectedPermissions);
    }

    public static Resource fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        return jsonObject.stream().filter(field -> !Objects.equals(field.getKey(), JsonSchemaVersion.getJsonKey())).findFirst().map(field -> ImmutableResource.of(ResourceKey.newInstance(field.getKeyName()), field.getValue())).orElseThrow(() -> new DittoJsonException((RuntimeException)JsonMissingFieldException.newBuilder().message("The JSON object for the 'resource' is missing.").build()));
    }

    @Override
    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public String getType() {
        return this.resourceKey.getResourceType();
    }

    @Override
    public JsonPointer getPath() {
        return this.resourceKey.getResourcePath();
    }

    @Override
    public String getFullQualifiedPath() {
        return this.resourceKey.toString();
    }

    @Override
    public EffectedPermissions getEffectedPermissions() {
        return this.effectedPermissions;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        return (JsonObject)this.effectedPermissions.toJson(schemaVersion, thePredicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableResource resource = (ImmutableResource)o;
        return Objects.equals(this.resourceKey, resource.resourceKey) && Objects.equals(this.effectedPermissions, resource.effectedPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.resourceKey, this.effectedPermissions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [resourceKey=" + this.resourceKey + ", effectedPermissions=" + this.effectedPermissions + "]";
    }
}

