/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.ResourceKey;

@Immutable
final class ImmutableResourceKey
implements ResourceKey {
    private final String resourceType;
    private final JsonPointer resourcePath;

    private ImmutableResourceKey(String resourceType, JsonPointer resourcePath) {
        this.resourceType = resourceType;
        this.resourcePath = resourcePath;
    }

    public static ImmutableResourceKey newInstance(CharSequence type, JsonPointer path) {
        return new ImmutableResourceKey(ConditionChecker.argumentNotEmpty((CharSequence)type, (String)"type").toString(), (JsonPointer)ConditionChecker.checkNotNull((Object)path, (String)"path"));
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public JsonPointer getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableResourceKey that = (ImmutableResourceKey)o;
        return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourcePath, that.resourcePath);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.resourcePath);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.resourceType + ":" + this.resourcePath.toString();
    }
}

