/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.ImmutableResource;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;

@Immutable
final class ImmutableResources
implements Resources {
    private final Map<ResourceKey, Resource> resources;

    private ImmutableResources(Map<ResourceKey, Resource> theResources) {
        ConditionChecker.checkNotNull(theResources, (String)"Resources");
        this.resources = Collections.unmodifiableMap(new LinkedHashMap<ResourceKey, Resource>(theResources));
    }

    public static ImmutableResources of(Iterable<Resource> resources) {
        ConditionChecker.checkNotNull(resources, (String)"resources");
        LinkedHashMap<ResourceKey, Resource> resourcesMap = new LinkedHashMap<ResourceKey, Resource>();
        resources.forEach(resource -> {
            Resource existingResource = resourcesMap.put(resource.getResourceKey(), (Resource)resource);
            if (null != existingResource) {
                String msgTemplate = "There is more than one Resource with the path <{0}>!";
                throw new IllegalArgumentException(MessageFormat.format("There is more than one Resource with the path <{0}>!", resource.getPath()));
            }
        });
        return new ImmutableResources(resourcesMap);
    }

    public static Resources fromJson(JsonObject jsonObject) {
        List<Resource> theResources = jsonObject.stream().filter(field -> !Objects.equals(field.getKey(), JsonSchemaVersion.getJsonKey())).map(field -> ImmutableResource.of(ResourceKey.newInstance(field.getKeyName()), field.getValue())).collect(Collectors.toList());
        return ImmutableResources.of(theResources);
    }

    @Override
    public Optional<Resource> getResource(ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"ResourceKey of the resource to retrieve");
        return Optional.ofNullable(this.resources.get(resourceKey));
    }

    @Override
    public Resources setResource(Resource resource) {
        ConditionChecker.checkNotNull((Object)resource, (String)"resource to set");
        Resources result = this;
        Resource existingResource = this.resources.get(resource.getResourceKey());
        if (!Objects.equals(existingResource, resource)) {
            result = this.createNewResourcesWithNewResource(resource);
        }
        return result;
    }

    private Resources createNewResourcesWithNewResource(Resource newResource) {
        Map<ResourceKey, Resource> resourcesCopy = this.copyResources();
        resourcesCopy.put(newResource.getResourceKey(), newResource);
        return new ImmutableResources(resourcesCopy);
    }

    private Map<ResourceKey, Resource> copyResources() {
        return new LinkedHashMap<ResourceKey, Resource>(this.resources);
    }

    @Override
    public Resources removeResource(ResourceKey resourceKey) {
        ConditionChecker.checkNotNull((Object)resourceKey, (String)"ResourceKey of the resource to remove");
        if (!this.resources.containsKey(resourceKey)) {
            return this;
        }
        Map<ResourceKey, Resource> resourcesCopy = this.copyResources();
        resourcesCopy.remove(resourceKey);
        return new ImmutableResources(resourcesCopy);
    }

    @Override
    public int getSize() {
        return this.resources.size();
    }

    @Override
    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().setAll((Iterable)this.resourcesToJson(schemaVersion, thePredicate), predicate).build();
    }

    private JsonObject resourcesToJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        this.resources.values().forEach(resource -> {
            JsonKey key = JsonKey.of((CharSequence)resource.getFullQualifiedPath());
            JsonValue value = resource.toJson(schemaVersion, thePredicate);
            JsonFieldDefinition fieldDefinition = JsonFactory.newJsonObjectFieldDefinition((CharSequence)key, (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
            JsonField field = JsonFactory.newField((JsonKey)key, (JsonValue)value, (JsonFieldDefinition)fieldDefinition);
            jsonObjectBuilder.set(field, predicate);
        });
        return jsonObjectBuilder.build();
    }

    @Override
    public Iterator<Resource> iterator() {
        return new LinkedHashSet<Resource>(this.resources.values()).iterator();
    }

    @Override
    public Stream<Resource> stream() {
        return this.resources.values().stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableResources resources1 = (ImmutableResources)o;
        return Objects.equals(this.resources, resources1.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [resources=" + this.resources + "]";
    }
}

