/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.ImmutableSubjectType;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectAnnouncement;
import org.eclipse.ditto.model.policies.SubjectExpiry;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.SubjectType;

@Immutable
final class ImmutableSubject
implements Subject {
    private final SubjectId subjectId;
    private final SubjectType subjectType;
    @Nullable
    private final SubjectExpiry subjectExpiry;
    @Nullable
    private final SubjectAnnouncement subjectAnnouncement;

    private ImmutableSubject(SubjectId subjectId, SubjectType subjectType, @Nullable SubjectExpiry subjectExpiry, @Nullable SubjectAnnouncement subjectAnnouncement) {
        this.subjectId = (SubjectId)ConditionChecker.checkNotNull((Object)subjectId, (String)"subjectId");
        this.subjectType = (SubjectType)ConditionChecker.checkNotNull((Object)subjectType, (String)"subjectType");
        this.subjectExpiry = subjectExpiry;
        this.subjectAnnouncement = subjectAnnouncement;
    }

    public static Subject of(SubjectId subjectId) {
        return new ImmutableSubject(subjectId, SubjectType.GENERATED, null, null);
    }

    public static Subject of(SubjectId subjectId, SubjectType subjectType) {
        return new ImmutableSubject(subjectId, subjectType, null, null);
    }

    public static Subject of(SubjectId subjectId, SubjectType subjectType, @Nullable SubjectExpiry subjectExpiry) {
        return new ImmutableSubject(subjectId, subjectType, subjectExpiry, null);
    }

    public static Subject of(SubjectId subjectId, SubjectType subjectType, @Nullable SubjectExpiry subjectExpiry, @Nullable SubjectAnnouncement subjectAnnouncement) {
        return new ImmutableSubject(subjectId, subjectType, subjectExpiry, subjectAnnouncement);
    }

    public static Subject fromJson(CharSequence subjectIssuerWithId, JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)subjectIssuerWithId, (String)"subjectIssuerWithId");
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"jsonObject");
        String subjectTypeValue = (String)jsonObject.getValue(Subject.JsonFields.TYPE).orElseThrow(() -> new DittoJsonException((RuntimeException)JsonMissingFieldException.newBuilder().message("The 'type' for the 'subject' is missing.").build()));
        SubjectExpiry subjectExpiry = jsonObject.getValue(Subject.JsonFields.EXPIRY).map(SubjectExpiry::newInstance).orElse(null);
        SubjectAnnouncement subjectAnnouncement = jsonObject.getValue(Subject.JsonFields.ANNOUNCEMENT).map(SubjectAnnouncement::fromJson).orElse(null);
        return new ImmutableSubject(SubjectId.newInstance(subjectIssuerWithId), ImmutableSubjectType.of(subjectTypeValue), subjectExpiry, subjectAnnouncement);
    }

    @Override
    public SubjectId getId() {
        return this.subjectId;
    }

    @Override
    public SubjectType getType() {
        return this.subjectType;
    }

    @Override
    public Optional<SubjectExpiry> getExpiry() {
        return Optional.ofNullable(this.subjectExpiry);
    }

    @Override
    public Optional<SubjectAnnouncement> getAnnouncement() {
        return Optional.ofNullable(this.subjectAnnouncement);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(Subject.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate).set(Subject.JsonFields.TYPE, (Object)this.subjectType.toString(), predicate);
        if (null != this.subjectExpiry) {
            jsonObjectBuilder.set(Subject.JsonFields.EXPIRY, (Object)this.subjectExpiry.toString());
        }
        if (null != this.subjectAnnouncement) {
            jsonObjectBuilder.set(Subject.JsonFields.ANNOUNCEMENT, (Object)((JsonObject)this.subjectAnnouncement.toJson()));
        }
        return jsonObjectBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSubject that = (ImmutableSubject)o;
        return Objects.equals(this.subjectId, that.subjectId) && Objects.equals(this.subjectType, that.subjectType) && Objects.equals(this.subjectExpiry, that.subjectExpiry) && Objects.equals(this.subjectAnnouncement, that.subjectAnnouncement);
    }

    public int hashCode() {
        return Objects.hash(this.subjectId, this.subjectType, this.subjectExpiry, this.subjectAnnouncement);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [subjectId=" + this.subjectId + ", subjectType=" + this.subjectType + ", subjectExpiry=" + this.subjectExpiry + ", subjectAnnouncement=" + this.subjectAnnouncement + "]";
    }
}

