/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.DittoDuration;
import org.eclipse.ditto.model.policies.SubjectAnnouncement;
import org.eclipse.ditto.model.policies.SubjectAnnouncementInvalidException;

@Immutable
final class ImmutableSubjectAnnouncement
implements SubjectAnnouncement {
    private static final Set<ChronoUnit> BEFORE_EXPIRY_DURATION_UNITS = EnumSet.of(ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS);
    @Nullable
    private final DittoDuration beforeExpiry;
    private final boolean whenDeleted;

    ImmutableSubjectAnnouncement(@Nullable DittoDuration beforeExpiry, boolean whenDeleted) {
        this.beforeExpiry = beforeExpiry;
        this.whenDeleted = whenDeleted;
    }

    static ImmutableSubjectAnnouncement fromJson(JsonObject jsonObject) {
        Optional beforeExpiryString = jsonObject.getValue(SubjectAnnouncement.JsonFields.BEFORE_EXPIRY);
        boolean whenDeleted = jsonObject.getValue(SubjectAnnouncement.JsonFields.WHEN_DELETED).orElse(false);
        if (beforeExpiryString.isPresent()) {
            try {
                DittoDuration beforeExpiry = DittoDuration.parseDuration((CharSequence)((CharSequence)beforeExpiryString.get()));
                if (!BEFORE_EXPIRY_DURATION_UNITS.contains(beforeExpiry.getChronoUnit())) {
                    throw (SubjectAnnouncementInvalidException)SubjectAnnouncementInvalidException.newBuilder((CharSequence)beforeExpiryString.get()).build();
                }
                return new ImmutableSubjectAnnouncement(beforeExpiry, whenDeleted);
            }
            catch (IllegalArgumentException e) {
                throw (SubjectAnnouncementInvalidException)SubjectAnnouncementInvalidException.newBuilder((CharSequence)beforeExpiryString.get()).build();
            }
        }
        return new ImmutableSubjectAnnouncement(null, whenDeleted);
    }

    @Override
    public Optional<DittoDuration> getBeforeExpiry() {
        return Optional.ofNullable(this.beforeExpiry);
    }

    @Override
    public boolean isWhenDeleted() {
        return this.whenDeleted;
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = JsonObject.newBuilder();
        if (this.beforeExpiry != null) {
            builder.set(SubjectAnnouncement.JsonFields.BEFORE_EXPIRY, (Object)this.beforeExpiry.toString());
        }
        builder.set(SubjectAnnouncement.JsonFields.WHEN_DELETED, (Object)this.whenDeleted);
        return builder.build();
    }

    public boolean equals(Object other) {
        if (other instanceof ImmutableSubjectAnnouncement) {
            ImmutableSubjectAnnouncement that = (ImmutableSubjectAnnouncement)other;
            return Objects.equals(this.beforeExpiry, that.beforeExpiry) && this.whenDeleted == that.whenDeleted;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.beforeExpiry, this.whenDeleted);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[beforeExpiry=" + this.beforeExpiry + ", whenDeleted=" + this.whenDeleted + "]";
    }
}

