/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.SubjectExpiry;
import org.eclipse.ditto.model.policies.SubjectExpiryInvalidException;

@Immutable
final class ImmutableSubjectExpiry
implements SubjectExpiry {
    private final Instant timestamp;

    private ImmutableSubjectExpiry(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public static SubjectExpiry of(CharSequence expiry) {
        Instant timestamp;
        if (expiry instanceof SubjectExpiry) {
            return (SubjectExpiry)expiry;
        }
        try {
            timestamp = Instant.parse((CharSequence)ConditionChecker.checkNotNull((Object)expiry, (String)"expiry"));
        }
        catch (DateTimeParseException e) {
            throw (SubjectExpiryInvalidException)SubjectExpiryInvalidException.newBuilder(expiry).cause(e).build();
        }
        return new ImmutableSubjectExpiry(timestamp);
    }

    public static SubjectExpiry of(Instant expiry) {
        return new ImmutableSubjectExpiry((Instant)ConditionChecker.checkNotNull((Object)expiry, (String)"expiry"));
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isExpired() {
        return this.timestamp.isBefore(Instant.now());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSubjectExpiry that = (ImmutableSubjectExpiry)o;
        return Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.timestamp.toString();
    }
}

