/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.Placeholders;
import org.eclipse.ditto.model.base.entity.validation.NoControlCharactersValidator;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.SubjectIdInvalidException;
import org.eclipse.ditto.model.policies.SubjectIssuer;

@Immutable
final class ImmutableSubjectId
implements SubjectId {
    private static final String IGNORED_DELIMITER = "://";
    private static final SubjectIssuer EMPTY_ISSUER = PoliciesModelFactory.newSubjectIssuer("");
    private final SubjectIssuer issuer;
    private final String subject;

    private ImmutableSubjectId(SubjectIssuer issuer, String subject) {
        this.issuer = issuer;
        this.subject = subject;
    }

    public static SubjectId of(SubjectIssuer issuer, CharSequence subject) {
        ConditionChecker.checkNotNull((Object)issuer, (String)"issuer");
        ConditionChecker.argumentNotEmpty((CharSequence)subject, (String)"subject");
        String subjectIdAsString = issuer.toString() + ":" + subject.toString();
        NoControlCharactersValidator validator = NoControlCharactersValidator.getInstance((CharSequence)subjectIdAsString);
        if (!validator.isValid()) {
            throw (SubjectIdInvalidException)SubjectIdInvalidException.newBuilder(subjectIdAsString).description(validator.getReason().orElse(null)).build();
        }
        return new ImmutableSubjectId(issuer, subject.toString());
    }

    public static SubjectId of(CharSequence subjectIssuerWithId) {
        ConditionChecker.argumentNotEmpty((CharSequence)subjectIssuerWithId, (String)"subjectIssuerWithId");
        if (Placeholders.containsAnyPlaceholder((CharSequence)subjectIssuerWithId)) {
            return ImmutableSubjectId.of(EMPTY_ISSUER, subjectIssuerWithId);
        }
        String subjectIdAsString = subjectIssuerWithId.toString();
        if (!subjectIdAsString.contains(":")) {
            throw (SubjectIdInvalidException)SubjectIdInvalidException.newBuilder(subjectIssuerWithId).build();
        }
        int ignoredDelimiterIndex = subjectIdAsString.indexOf(IGNORED_DELIMITER);
        int lastDelimiter = ignoredDelimiterIndex >= 0 ? subjectIdAsString.indexOf(":", ignoredDelimiterIndex + IGNORED_DELIMITER.length()) : subjectIdAsString.indexOf(":");
        SubjectIssuer issuer = PoliciesModelFactory.newSubjectIssuer(subjectIdAsString.substring(0, lastDelimiter));
        String subject = subjectIdAsString.replaceFirst(Pattern.quote(issuer.toString() + ":"), "");
        return ImmutableSubjectId.of(issuer, subject);
    }

    @Override
    public SubjectIssuer getIssuer() {
        return this.issuer;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSubjectId that = (ImmutableSubjectId)o;
        return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.subject);
    }

    @Override
    @Nonnull
    public String toString() {
        if (this.issuer.length() == 0) {
            return this.subject;
        }
        return this.issuer + ":" + this.subject;
    }
}

