/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.Subjects;

@Immutable
final class ImmutableSubjects
implements Subjects {
    private final Map<SubjectId, Subject> subjects;

    private ImmutableSubjects(Map<SubjectId, Subject> theSubjects) {
        Objects.requireNonNull(theSubjects, "The Subjects must not be null!");
        this.subjects = Collections.unmodifiableMap(new LinkedHashMap<SubjectId, Subject>(theSubjects));
    }

    public static ImmutableSubjects of(Iterable<Subject> subjects) {
        ConditionChecker.checkNotNull(subjects, (String)"subjects");
        LinkedHashMap<SubjectId, Subject> subjectsMap = new LinkedHashMap<SubjectId, Subject>();
        subjects.forEach(subject -> {
            Subject existingSubject = subjectsMap.put(subject.getId(), (Subject)subject);
            if (null != existingSubject) {
                String msgTemplate = "There is more than one Subject with the ID <{0}>!";
                throw new IllegalArgumentException(MessageFormat.format("There is more than one Subject with the ID <{0}>!", subject.getId()));
            }
        });
        return new ImmutableSubjects(subjectsMap);
    }

    public static ImmutableSubjects fromJson(JsonObject jsonObject) {
        Function<JsonField, Subject> toSubject = jsonField -> {
            JsonValue jsonValue = jsonField.getValue();
            if (!jsonValue.isObject()) {
                throw new JsonParseException(MessageFormat.format("<{0}> is not a JSON object!", jsonValue));
            }
            return PoliciesModelFactory.newSubject((CharSequence)jsonField.getKey(), jsonValue.asObject());
        };
        List<Subject> theSubjects = jsonObject.stream().filter(field -> !Objects.equals(field.getKey(), JsonSchemaVersion.getJsonKey())).map(toSubject).collect(Collectors.toList());
        return ImmutableSubjects.of(theSubjects);
    }

    @Override
    public Optional<Subject> getSubject(SubjectId subjectId) {
        ConditionChecker.checkNotNull((Object)subjectId, (String)"subject identifier of the subject to retrieve");
        return Optional.ofNullable(this.subjects.get(subjectId));
    }

    @Override
    public Subjects setSubject(Subject subject) {
        ConditionChecker.checkNotNull((Object)subject, (String)"subject to set");
        Subjects result = this;
        Subject existingSubject = this.subjects.get(subject.getId());
        if (!Objects.equals(existingSubject, subject)) {
            result = this.createNewSubjectsWithNewSubject(subject);
        }
        return result;
    }

    private Subjects createNewSubjectsWithNewSubject(Subject newSubject) {
        Map<SubjectId, Subject> subjectsCopy = this.copySubjects();
        subjectsCopy.put(newSubject.getId(), newSubject);
        return new ImmutableSubjects(subjectsCopy);
    }

    private Map<SubjectId, Subject> copySubjects() {
        return new LinkedHashMap<SubjectId, Subject>(this.subjects);
    }

    @Override
    public Subjects removeSubject(SubjectId subjectId) {
        ConditionChecker.checkNotNull((Object)subjectId, (String)"subject identifier of the subject to remove");
        if (!this.subjects.containsKey(subjectId)) {
            return this;
        }
        Map<SubjectId, Subject> subjectsCopy = this.copySubjects();
        subjectsCopy.remove(subjectId);
        return new ImmutableSubjects(subjectsCopy);
    }

    @Override
    public int getSize() {
        return this.subjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        return JsonFactory.newObjectBuilder().setAll((Iterable)this.subjectsToJson(schemaVersion, thePredicate), predicate).build();
    }

    private JsonObject subjectsToJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        this.subjects.values().forEach(subject -> {
            JsonKey key = JsonKey.of((CharSequence)subject.getId());
            JsonValue value = subject.toJson(schemaVersion, thePredicate);
            JsonFieldDefinition fieldDefinition = JsonFactory.newJsonObjectFieldDefinition((CharSequence)key, (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
            JsonField field = JsonFactory.newField((JsonKey)key, (JsonValue)value, (JsonFieldDefinition)fieldDefinition);
            jsonObjectBuilder.set(field, predicate);
        });
        return jsonObjectBuilder.build();
    }

    @Override
    public Iterator<Subject> iterator() {
        return new LinkedHashSet<Subject>(this.subjects.values()).iterator();
    }

    @Override
    public Stream<Subject> stream() {
        return this.subjects.values().stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableSubjects)) {
            return false;
        }
        ImmutableSubjects that = (ImmutableSubjects)o;
        return Objects.equals(this.subjects, that.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.subjects);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [subjects=" + this.subjects + "]";
    }
}

