/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.validation.NoControlCharactersValidator;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.ImmutableEffectedPermissions;
import org.eclipse.ditto.model.policies.ImmutableLabel;
import org.eclipse.ditto.model.policies.ImmutablePermissions;
import org.eclipse.ditto.model.policies.ImmutablePolicy;
import org.eclipse.ditto.model.policies.ImmutablePolicyBuilder;
import org.eclipse.ditto.model.policies.ImmutablePolicyEntry;
import org.eclipse.ditto.model.policies.ImmutablePolicyRevision;
import org.eclipse.ditto.model.policies.ImmutableResource;
import org.eclipse.ditto.model.policies.ImmutableResourceKey;
import org.eclipse.ditto.model.policies.ImmutableResources;
import org.eclipse.ditto.model.policies.ImmutableSubject;
import org.eclipse.ditto.model.policies.ImmutableSubjectExpiry;
import org.eclipse.ditto.model.policies.ImmutableSubjectId;
import org.eclipse.ditto.model.policies.ImmutableSubjectIssuer;
import org.eclipse.ditto.model.policies.ImmutableSubjectType;
import org.eclipse.ditto.model.policies.ImmutableSubjects;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyBuilder;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyEntryInvalidException;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.policies.PolicyLifecycle;
import org.eclipse.ditto.model.policies.PolicyRevision;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectExpiry;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.SubjectIssuer;
import org.eclipse.ditto.model.policies.SubjectType;
import org.eclipse.ditto.model.policies.Subjects;

@Immutable
public final class PoliciesModelFactory {
    private PoliciesModelFactory() {
        throw new AssertionError();
    }

    public static Label newLabel(CharSequence labelValue) {
        if (labelValue instanceof Label) {
            return (Label)labelValue;
        }
        return ImmutableLabel.of(labelValue);
    }

    public static SubjectIssuer newSubjectIssuer(CharSequence subjectIssuer) {
        return ImmutableSubjectIssuer.of(subjectIssuer);
    }

    public static SubjectId newSubjectId(SubjectIssuer issuer, CharSequence subject) {
        return ImmutableSubjectId.of(issuer, subject);
    }

    public static SubjectId newSubjectId(CharSequence subjectIssuerWithId) {
        ConditionChecker.checkNotNull((Object)subjectIssuerWithId, (String)"subjectIssuerWithId");
        if (SubjectId.class.isAssignableFrom(subjectIssuerWithId.getClass())) {
            return (SubjectId)subjectIssuerWithId;
        }
        return ImmutableSubjectId.of(subjectIssuerWithId);
    }

    public static SubjectType newSubjectType(CharSequence subjectType) {
        return ImmutableSubjectType.of(subjectType);
    }

    public static SubjectExpiry newSubjectExpiry(CharSequence expiry) {
        return ImmutableSubjectExpiry.of(expiry);
    }

    public static SubjectExpiry newSubjectExpiry(Instant expiry) {
        return ImmutableSubjectExpiry.of(expiry);
    }

    public static Subject newSubject(SubjectId subjectId) {
        return ImmutableSubject.of(subjectId);
    }

    public static Subject newSubject(SubjectId subjectId, SubjectType subjectType) {
        return ImmutableSubject.of(subjectId, subjectType);
    }

    public static Subject newSubject(SubjectId subjectId, SubjectType subjectType, @Nullable SubjectExpiry subjectExpiry) {
        return ImmutableSubject.of(subjectId, subjectType, subjectExpiry);
    }

    public static Subject newSubject(CharSequence subjectIssuerWithId, JsonObject jsonObject) {
        return ImmutableSubject.fromJson(subjectIssuerWithId, jsonObject);
    }

    public static Subjects emptySubjects() {
        return ImmutableSubjects.of(Collections.emptyList());
    }

    public static Subjects newSubjects(Iterable<Subject> subjects) {
        if (subjects instanceof Subjects) {
            return (Subjects)subjects;
        }
        return ImmutableSubjects.of(subjects);
    }

    public static Subjects newSubjects(Subject subject, Subject ... furtherSubjects) {
        ConditionChecker.checkNotNull((Object)subject, (String)"mandatory subject");
        ConditionChecker.checkNotNull((Object)furtherSubjects, (String)"additional subjects");
        ArrayList<Subject> allSubjects = new ArrayList<Subject>(1 + furtherSubjects.length);
        allSubjects.add(subject);
        Collections.addAll(allSubjects, furtherSubjects);
        return PoliciesModelFactory.newSubjects(allSubjects);
    }

    public static Subjects newSubjects(JsonObject jsonObject) {
        return ImmutableSubjects.fromJson(jsonObject);
    }

    public static ResourceKey newResourceKey(CharSequence typeWithPath) {
        if (typeWithPath instanceof ResourceKey) {
            return (ResourceKey)typeWithPath;
        }
        ConditionChecker.argumentNotEmpty((CharSequence)typeWithPath, (String)"typeWithPath");
        NoControlCharactersValidator validator = NoControlCharactersValidator.getInstance((CharSequence)typeWithPath);
        if (!validator.isValid()) {
            throw (PolicyEntryInvalidException)PolicyEntryInvalidException.newBuilder().message("The Policy Resource " + typeWithPath + " is invalid").description((String)validator.getReason().orElse(null)).build();
        }
        String[] typeWithPathSplit = PoliciesModelFactory.splitTypeWithPath(typeWithPath.toString());
        return ImmutableResourceKey.newInstance((CharSequence)typeWithPathSplit[0], JsonPointer.of((CharSequence)typeWithPathSplit[1]));
    }

    private static String[] splitTypeWithPath(String typeWithPath) {
        String[] split = typeWithPath.split(":", 2);
        if (split.length < 2) {
            throw new DittoJsonException((RuntimeException)JsonParseException.newBuilder().message("The provided string was not in the expected format 'type:path'").build());
        }
        return split;
    }

    public static ResourceKey newResourceKey(CharSequence resourceType, CharSequence resourcePath) {
        ConditionChecker.checkNotNull((Object)resourcePath, (String)"resource path");
        return ImmutableResourceKey.newInstance(resourceType, JsonPointer.of((CharSequence)resourcePath));
    }

    public static ResourceKey newResourceKey(JsonPointer pointer) {
        ConditionChecker.checkNotNull((Object)pointer, (String)"pointer");
        ConditionChecker.checkNotEmpty((CharSequence)pointer, (String)"pointer");
        String typeWithPath = pointer.toString().substring(1);
        return PoliciesModelFactory.newResourceKey(typeWithPath);
    }

    public static Resource newResource(CharSequence resourceType, CharSequence resourcePath, EffectedPermissions effectedPermissions) {
        return PoliciesModelFactory.newResource(PoliciesModelFactory.newResourceKey(resourceType, resourcePath), effectedPermissions);
    }

    public static Resource newResource(ResourceKey resourceKey, JsonValue effectedPermissions) {
        return ImmutableResource.of(resourceKey, effectedPermissions);
    }

    public static Resource newResource(ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
        return ImmutableResource.of(resourceKey, effectedPermissions);
    }

    public static Resources emptyResources() {
        return ImmutableResources.of(Collections.emptyList());
    }

    public static Resources newResources(Iterable<Resource> resources) {
        if (resources instanceof Resources) {
            return (Resources)resources;
        }
        return ImmutableResources.of(resources);
    }

    public static Resources newResources(Resource resource, Resource ... furtherResources) {
        ConditionChecker.checkNotNull((Object)resource, (String)"mandatory resource");
        ConditionChecker.checkNotNull((Object)furtherResources, (String)"additional resources");
        ArrayList<Resource> allResources = new ArrayList<Resource>(1 + furtherResources.length);
        allResources.add(resource);
        Collections.addAll(allResources, furtherResources);
        return PoliciesModelFactory.newResources(allResources);
    }

    public static Resources newResources(JsonObject jsonObject) {
        return ImmutableResources.fromJson(jsonObject);
    }

    public static EffectedPermissions newEffectedPermissions(@Nullable Iterable<String> grantedPermissions, @Nullable Iterable<String> revokedPermissions) {
        return ImmutableEffectedPermissions.of(PoliciesModelFactory.getOrEmptyCollection(grantedPermissions), PoliciesModelFactory.getOrEmptyCollection(revokedPermissions));
    }

    private static Iterable<String> getOrEmptyCollection(@Nullable Iterable<String> iterable) {
        return null != iterable ? iterable : Collections.emptySet();
    }

    public static PolicyRevision newPolicyRevision(long revisionNumber) {
        return ImmutablePolicyRevision.of(revisionNumber);
    }

    public static Permissions noPermissions() {
        return ImmutablePermissions.none();
    }

    public static Permissions newPermissions(Collection<String> permissions) {
        return ImmutablePermissions.of(permissions);
    }

    public static Permissions newPermissions(String permission, String ... furtherPermissions) {
        return ImmutablePermissions.of(permission, furtherPermissions);
    }

    public static PolicyEntry newPolicyEntry(CharSequence label, Iterable<Subject> subjects, Iterable<Resource> resources) {
        return ImmutablePolicyEntry.of(Label.of(label), PoliciesModelFactory.newSubjects(subjects), PoliciesModelFactory.newResources(resources));
    }

    public static PolicyEntry newPolicyEntry(CharSequence label, JsonObject jsonObject) {
        return ImmutablePolicyEntry.fromJson(label, jsonObject);
    }

    public static PolicyEntry newPolicyEntry(CharSequence label, JsonValue jsonValue) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> ((JsonValue)jsonValue).asObject());
        return ImmutablePolicyEntry.fromJson(label, jsonObject);
    }

    public static PolicyEntry newPolicyEntry(CharSequence label, String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return ImmutablePolicyEntry.fromJson(label, jsonObject);
    }

    public static Iterable<PolicyEntry> newPolicyEntries(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object");
        return jsonObject.stream().map(jsonField -> PoliciesModelFactory.newPolicyEntry((CharSequence)jsonField.getKey(), jsonField.getValue())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Iterable<PolicyEntry> newPolicyEntries(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return PoliciesModelFactory.newPolicyEntries(jsonObject);
    }

    public static PolicyBuilder newPolicyBuilder() {
        return ImmutablePolicyBuilder.newInstance();
    }

    @Deprecated
    public static PolicyBuilder newPolicyBuilder(CharSequence id) {
        return ImmutablePolicyBuilder.of(PolicyId.of(id));
    }

    public static PolicyBuilder newPolicyBuilder(PolicyId id) {
        return ImmutablePolicyBuilder.of(id);
    }

    public static PolicyBuilder newPolicyBuilder(Policy existingPolicy) {
        return ImmutablePolicyBuilder.of(existingPolicy);
    }

    @Deprecated
    public static PolicyBuilder newPolicyBuilder(CharSequence id, Iterable<PolicyEntry> policyEntries) {
        return ImmutablePolicyBuilder.of(PolicyId.of(id), policyEntries);
    }

    public static PolicyBuilder newPolicyBuilder(PolicyId id, Iterable<PolicyEntry> policyEntries) {
        return ImmutablePolicyBuilder.of(id, policyEntries);
    }

    @Deprecated
    public static Policy newPolicy(CharSequence id, PolicyEntry entry, PolicyEntry ... furtherEntries) {
        ConditionChecker.checkNotNull((Object)entry, (String)"mandatory entry");
        ConditionChecker.checkNotNull((Object)furtherEntries, (String)"additional policy entries");
        HashSet<PolicyEntry> allEntries = new HashSet<PolicyEntry>(1 + furtherEntries.length);
        allEntries.add(entry);
        Collections.addAll(allEntries, furtherEntries);
        return ImmutablePolicy.of(PolicyId.of(id), PolicyLifecycle.ACTIVE, PolicyRevision.newInstance(1L), null, null, allEntries);
    }

    public static Policy newPolicy(PolicyId id, PolicyEntry entry, PolicyEntry ... furtherEntries) {
        ConditionChecker.checkNotNull((Object)entry, (String)"mandatory entry");
        ConditionChecker.checkNotNull((Object)furtherEntries, (String)"additional policy entries");
        HashSet<PolicyEntry> allEntries = new HashSet<PolicyEntry>(1 + furtherEntries.length);
        allEntries.add(entry);
        Collections.addAll(allEntries, furtherEntries);
        return ImmutablePolicy.of(id, PolicyLifecycle.ACTIVE, PolicyRevision.newInstance(1L), null, null, allEntries);
    }

    @Deprecated
    public static Policy newPolicy(CharSequence id, Iterable<PolicyEntry> entries) {
        return ImmutablePolicy.of(PolicyId.of(id), PolicyLifecycle.ACTIVE, PolicyRevision.newInstance(1L), null, null, entries);
    }

    public static Policy newPolicy(PolicyId id, Iterable<PolicyEntry> entries) {
        return ImmutablePolicy.of(id, PolicyLifecycle.ACTIVE, PolicyRevision.newInstance(1L), null, null, entries);
    }

    public static Policy newPolicy(JsonObject jsonObject) {
        return ImmutablePolicy.fromJson(jsonObject);
    }

    public static Policy newPolicy(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return PoliciesModelFactory.newPolicy(jsonObject);
    }
}

