/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.Entity;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyBuilder;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.policies.PolicyLifecycle;
import org.eclipse.ditto.model.policies.PolicyRevision;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.Subjects;

public interface Policy
extends Iterable<PolicyEntry>,
Entity<PolicyRevision> {
    public static final String INLINED_FIELD_NAME = "_policy";

    @Deprecated
    public static PolicyBuilder newBuilder(CharSequence id) {
        return Policy.newBuilder(PolicyId.of(id));
    }

    public static PolicyBuilder newBuilder(PolicyId policyId) {
        return PoliciesModelFactory.newPolicyBuilder(policyId);
    }

    public static PolicyBuilder newBuilder() {
        return PoliciesModelFactory.newPolicyBuilder();
    }

    default public PolicyBuilder toBuilder() {
        return PoliciesModelFactory.newPolicyBuilder(this);
    }

    public Optional<PolicyId> getEntityId();

    @Deprecated
    default public Optional<String> getId() {
        return this.getEntityId().map(String::valueOf);
    }

    default public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public Optional<String> getNamespace();

    public Optional<PolicyLifecycle> getLifecycle();

    default public boolean hasLifecycle(@Nullable PolicyLifecycle lifecycle) {
        return this.getLifecycle().filter(actualLifecycle -> Objects.equals(actualLifecycle, (Object)lifecycle)).isPresent();
    }

    public Set<Label> getLabels();

    public boolean contains(CharSequence var1);

    public Policy setEntry(PolicyEntry var1);

    public Optional<PolicyEntry> getEntryFor(CharSequence var1);

    public Policy removeEntry(CharSequence var1);

    public Policy removeEntry(PolicyEntry var1);

    public Policy setSubjectsFor(CharSequence var1, Subjects var2);

    public Policy setSubjectFor(CharSequence var1, Subject var2);

    public Policy removeSubjectFor(CharSequence var1, SubjectId var2);

    default public Policy removeSubjectFor(CharSequence label, Subject subject) {
        ConditionChecker.checkNotNull((Object)subject, (String)"subject to be removed");
        return this.removeSubjectFor(label, subject.getId());
    }

    public Policy setResourcesFor(CharSequence var1, Resources var2);

    public Policy setResourceFor(CharSequence var1, Resource var2);

    default public Policy removeResourceFor(CharSequence label, String resourceType, CharSequence resourcePath) {
        return this.removeResourceFor(label, PoliciesModelFactory.newResourceKey(resourceType, resourcePath));
    }

    public Policy removeResourceFor(CharSequence var1, ResourceKey var2);

    default public Policy removeResourceFor(CharSequence label, Resource resource) {
        return this.removeResourceFor(label, ((Resource)ConditionChecker.checkNotNull((Object)resource, (String)"resource")).getResourceKey());
    }

    default public Policy setEffectedPermissionsFor(CharSequence label, ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
        return this.setResourceFor(label, PoliciesModelFactory.newResource(resourceKey, effectedPermissions));
    }

    default public Optional<EffectedPermissions> getEffectedPermissionsFor(CharSequence label, SubjectId subjectId, CharSequence resourceType, CharSequence resourcePath) {
        return this.getEffectedPermissionsFor(label, subjectId, PoliciesModelFactory.newResourceKey(resourceType, resourcePath));
    }

    public Optional<EffectedPermissions> getEffectedPermissionsFor(CharSequence var1, SubjectId var2, ResourceKey var3);

    public boolean isEmpty();

    public int getSize();

    public Set<PolicyEntry> getEntriesSet();

    public Stream<PolicyEntry> stream();

    default public JsonObject toInlinedJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        return JsonFactory.newObjectBuilder().set((CharSequence)INLINED_FIELD_NAME, this.toJson(schemaVersion, predicate)).build();
    }

    default public JsonObject toInlinedJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return JsonFactory.newObjectBuilder().set((CharSequence)INLINED_FIELD_NAME, (JsonValue)this.toJson(schemaVersion, fieldSelector)).build();
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> LIFECYCLE = JsonFactory.newStringFieldDefinition((CharSequence)"__lifecycle", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> NAMESPACE = JsonFactory.newStringFieldDefinition((CharSequence)"_namespace", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<Long> REVISION = JsonFactory.newLongFieldDefinition((CharSequence)"_revision", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> MODIFIED = JsonFactory.newStringFieldDefinition((CharSequence)"_modified", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> CREATED = JsonFactory.newStringFieldDefinition((CharSequence)"_created", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ID = JsonFactory.newStringFieldDefinition((CharSequence)"policyId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> ENTRIES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"entries", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

