/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.time.Instant;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.policies.EffectedPermissions;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.Permissions;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.policies.PolicyLifecycle;
import org.eclipse.ditto.model.policies.PolicyRevision;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.model.policies.SubjectIssuer;
import org.eclipse.ditto.model.policies.SubjectType;
import org.eclipse.ditto.model.policies.Subjects;

@NotThreadSafe
public interface PolicyBuilder {
    default public LabelScoped forLabel(CharSequence label) {
        return this.forLabel(Label.of(label));
    }

    public LabelScoped forLabel(Label var1);

    @Deprecated
    public PolicyBuilder setId(CharSequence var1);

    public PolicyBuilder setId(PolicyId var1);

    public PolicyBuilder setLifecycle(@Nullable PolicyLifecycle var1);

    default public PolicyBuilder setRevision(long revisionNumber) {
        return this.setRevision(PolicyRevision.newInstance(revisionNumber));
    }

    public PolicyBuilder setRevision(@Nullable PolicyRevision var1);

    public PolicyBuilder setModified(@Nullable Instant var1);

    public PolicyBuilder setCreated(@Nullable Instant var1);

    public PolicyBuilder set(PolicyEntry var1);

    public PolicyBuilder setAll(Iterable<PolicyEntry> var1);

    public PolicyBuilder remove(CharSequence var1);

    default public PolicyBuilder remove(PolicyEntry entry) {
        return this.remove(((PolicyEntry)ConditionChecker.checkNotNull((Object)entry, (String)"entry to be removed")).getLabel());
    }

    public PolicyBuilder removeAll(Iterable<PolicyEntry> var1);

    public PolicyBuilder setSubjectsFor(CharSequence var1, Subjects var2);

    default public PolicyBuilder setSubjectFor(CharSequence label, SubjectIssuer issuer, CharSequence subject, SubjectType subjectType) {
        return this.setSubjectFor(label, Subject.newInstance(issuer, subject, subjectType));
    }

    default public PolicyBuilder setSubjectFor(CharSequence label, CharSequence subjectIssuerWithId, SubjectType subjectType) {
        return this.setSubjectFor(label, Subject.newInstance(subjectIssuerWithId, subjectType));
    }

    public PolicyBuilder setSubjectFor(CharSequence var1, Subject var2);

    public PolicyBuilder removeSubjectFor(CharSequence var1, CharSequence var2);

    default public PolicyBuilder removeSubjectFor(CharSequence label, SubjectIssuer issuer, CharSequence subject) {
        return this.removeSubjectFor(label, SubjectId.newInstance(issuer, subject));
    }

    public PolicyBuilder removeSubjectFor(CharSequence var1, Subject var2);

    public PolicyBuilder setResourcesFor(CharSequence var1, Resources var2);

    public PolicyBuilder setResourceFor(CharSequence var1, Resource var2);

    public PolicyBuilder removeResourceFor(CharSequence var1, ResourceKey var2);

    public PolicyBuilder removeResourceFor(CharSequence var1, Resource var2);

    public PolicyBuilder setPermissionsFor(CharSequence var1, ResourceKey var2, EffectedPermissions var3);

    default public PolicyBuilder setGrantedPermissionsFor(CharSequence label, String resourceType, CharSequence resourcePath, Permissions grantedPermissions) {
        return this.setGrantedPermissionsFor(label, ResourceKey.newInstance(resourceType, resourcePath), grantedPermissions);
    }

    public PolicyBuilder setGrantedPermissionsFor(CharSequence var1, ResourceKey var2, Permissions var3);

    default public PolicyBuilder setGrantedPermissionsFor(CharSequence label, String resourceType, CharSequence resourcePath, String grantedPermission, String ... furtherGrantedPermissions) {
        return this.setGrantedPermissionsFor(label, ResourceKey.newInstance(resourceType, resourcePath), Permissions.newInstance(grantedPermission, furtherGrantedPermissions));
    }

    default public PolicyBuilder setGrantedPermissionsFor(CharSequence label, ResourceKey resourceKey, String grantedPermission, String ... furtherGrantedPermissions) {
        return this.setGrantedPermissionsFor(label, resourceKey, Permissions.newInstance(grantedPermission, furtherGrantedPermissions));
    }

    default public PolicyBuilder setRevokedPermissionsFor(CharSequence label, String resourceType, CharSequence resourcePath, Permissions revokedPermissions) {
        return this.setRevokedPermissionsFor(label, ResourceKey.newInstance(resourceType, resourcePath), revokedPermissions);
    }

    public PolicyBuilder setRevokedPermissionsFor(CharSequence var1, ResourceKey var2, Permissions var3);

    default public PolicyBuilder setRevokedPermissionsFor(CharSequence label, String resourceType, CharSequence resourcePath, String revokedPermission, String ... furtherRevokedPermissions) {
        return this.setRevokedPermissionsFor(label, ResourceKey.newInstance(resourceType, (CharSequence)JsonPointer.of((CharSequence)resourcePath)), Permissions.newInstance(revokedPermission, furtherRevokedPermissions));
    }

    default public PolicyBuilder setRevokedPermissionsFor(CharSequence label, ResourceKey resourceKey, String revokedPermission, String ... furtherRevokedPermissions) {
        return this.setRevokedPermissionsFor(label, resourceKey, Permissions.newInstance(revokedPermission, furtherRevokedPermissions));
    }

    public Policy build();

    public static interface LabelScoped
    extends PolicyBuilder {
        public Label getLabel();

        default public LabelScoped setSubjects(Subjects subjects) {
            this.setSubjectsFor(this.getLabel(), subjects);
            return this;
        }

        default public LabelScoped setSubject(SubjectIssuer issuer, CharSequence subject, SubjectType subjectType) {
            this.setSubjectFor(this.getLabel(), Subject.newInstance(issuer, subject, subjectType));
            return this;
        }

        default public LabelScoped setSubject(SubjectIssuer issuer, CharSequence subject) {
            this.setSubjectFor(this.getLabel(), Subject.newInstance(issuer, subject));
            return this;
        }

        default public LabelScoped setSubject(CharSequence subjectIssuerWithId, SubjectType subjectType) {
            this.setSubjectFor(this.getLabel(), Subject.newInstance(subjectIssuerWithId, subjectType));
            return this;
        }

        default public LabelScoped setSubject(Subject subject) {
            this.setSubjectFor(this.getLabel(), subject);
            return this;
        }

        default public LabelScoped removeSubject(CharSequence subjectIssuerWithId) {
            this.removeSubjectFor((CharSequence)this.getLabel(), SubjectId.newInstance(subjectIssuerWithId));
            return this;
        }

        default public LabelScoped removeSubject(SubjectIssuer issuer, CharSequence subject) {
            this.removeSubjectFor((CharSequence)this.getLabel(), SubjectId.newInstance(issuer, subject));
            return this;
        }

        default public LabelScoped removeSubject(SubjectId subjectId) {
            this.removeSubjectFor((CharSequence)this.getLabel(), subjectId);
            return this;
        }

        default public LabelScoped removeSubject(Subject subject) {
            this.removeSubjectFor((CharSequence)this.getLabel(), subject);
            return this;
        }

        default public LabelScoped setResources(Resources resources) {
            this.setResourcesFor(this.getLabel(), resources);
            return this;
        }

        default public LabelScoped setResource(Resource resource) {
            this.setResourceFor(this.getLabel(), resource);
            return this;
        }

        default public LabelScoped removeResource(ResourceKey resourceKey) {
            this.removeResourceFor((CharSequence)this.getLabel(), resourceKey);
            return this;
        }

        default public LabelScoped removeResource(Resource resource) {
            this.removeResourceFor((CharSequence)this.getLabel(), resource);
            return this;
        }

        default public LabelScoped setPermissions(ResourceKey resourceKey, EffectedPermissions effectedPermissions) {
            this.setPermissionsFor(this.getLabel(), resourceKey, effectedPermissions);
            return this;
        }

        default public LabelScoped setGrantedPermissions(String resourceType, CharSequence resourcePath, Permissions grantedPermissions) {
            this.setGrantedPermissions(resourceType, JsonPointer.of((CharSequence)resourcePath), grantedPermissions);
            return this;
        }

        default public LabelScoped setGrantedPermissions(String resourceType, JsonPointer resourcePath, Permissions grantedPermissions) {
            this.setGrantedPermissionsFor((CharSequence)this.getLabel(), resourceType, (CharSequence)resourcePath, grantedPermissions);
            return this;
        }

        default public LabelScoped setGrantedPermissions(ResourceKey resourceKey, Permissions grantedPermissions) {
            this.setGrantedPermissionsFor(this.getLabel(), resourceKey, grantedPermissions);
            return this;
        }

        default public LabelScoped setGrantedPermissions(ResourceKey resourceKey, String grantedPermission, String ... furtherGrantedPermissions) {
            this.setGrantedPermissionsFor((CharSequence)this.getLabel(), resourceKey, grantedPermission, furtherGrantedPermissions);
            return this;
        }

        default public LabelScoped setGrantedPermissions(String resourceType, CharSequence resourcePath, String grantedPermission, String ... furtherGrantedPermissions) {
            this.setGrantedPermissions(resourceType, JsonPointer.of((CharSequence)resourcePath), grantedPermission, furtherGrantedPermissions);
            return this;
        }

        default public LabelScoped setGrantedPermissions(String resourceType, JsonPointer resourcePath, String grantedPermission, String ... furtherGrantedPermissions) {
            this.setGrantedPermissionsFor((CharSequence)this.getLabel(), resourceType, (CharSequence)resourcePath, grantedPermission, furtherGrantedPermissions);
            return this;
        }

        default public LabelScoped setRevokedPermissions(String resourceType, CharSequence resourcePath, Permissions revokedPermissions) {
            this.setRevokedPermissions(resourceType, JsonPointer.of((CharSequence)resourcePath), revokedPermissions);
            return this;
        }

        default public LabelScoped setRevokedPermissions(String resourceType, JsonPointer resourcePath, Permissions revokedPermissions) {
            this.setRevokedPermissionsFor((CharSequence)this.getLabel(), resourceType, (CharSequence)resourcePath, revokedPermissions);
            return this;
        }

        default public LabelScoped setRevokedPermissions(ResourceKey resourceKey, Permissions revokedPermissions) {
            this.setRevokedPermissionsFor(this.getLabel(), resourceKey, revokedPermissions);
            return this;
        }

        default public LabelScoped setRevokedPermissions(ResourceKey resourceKey, String revokedPermission, String ... furtherRevokedPermissions) {
            this.setRevokedPermissionsFor((CharSequence)this.getLabel(), resourceKey, revokedPermission, furtherRevokedPermissions);
            return this;
        }

        default public LabelScoped setRevokedPermissions(String resourceType, CharSequence resourcePath, String revokedPermission, String ... furtherRevokedPermissions) {
            this.setRevokedPermissions(resourceType, JsonPointer.of((CharSequence)resourcePath), revokedPermission, furtherRevokedPermissions);
            return this;
        }

        default public LabelScoped setRevokedPermissions(String resourceType, JsonPointer resourcePath, String revokedPermission, String ... furtherRevokedPermissions) {
            this.setRevokedPermissionsFor((CharSequence)this.getLabel(), resourceType, (CharSequence)resourcePath, revokedPermission, furtherRevokedPermissions);
            return this;
        }

        public PolicyBuilder exitLabel();
    }
}

