/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyException;

@JsonParsableException(errorCode="policies:entry.invalid")
@Immutable
public final class PolicyEntryInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:entry.invalid";
    private static final String DEFAULT_MESSAGE = "The Policy Entry is invalid.";
    private static final String DEFAULT_DESCRIPTION = "Policy entry does not contain any known permission like 'READ' or 'WRITE'";
    private static final long serialVersionUID = 7032353950909423082L;

    private PolicyEntryInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static PolicyEntryInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (PolicyEntryInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static PolicyEntryInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (PolicyEntryInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public JsonSchemaVersion[] getSupportedSchemaVersions() {
        return new JsonSchemaVersion[]{JsonSchemaVersion.V_2};
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyEntryInvalidException> {
        private Builder() {
            this.message(PolicyEntryInvalidException.DEFAULT_MESSAGE);
            this.description(PolicyEntryInvalidException.DEFAULT_DESCRIPTION);
        }

        protected PolicyEntryInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new PolicyEntryInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

