/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.policies;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.entity.id.DefaultNamespacedEntityId;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityId;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityIdInvalidException;
import org.eclipse.ditto.model.base.entity.id.NamespacedEntityIdWithType;
import org.eclipse.ditto.model.base.entity.type.EntityType;
import org.eclipse.ditto.model.policies.PolicyConstants;
import org.eclipse.ditto.model.policies.PolicyIdInvalidException;

@Immutable
public final class PolicyId
extends NamespacedEntityIdWithType {
    private static final PolicyId DUMMY_ID = PolicyId.of((CharSequence)DefaultNamespacedEntityId.dummy());

    private PolicyId(NamespacedEntityId entityId) {
        super(entityId);
    }

    public static PolicyId of(CharSequence policyId) {
        if (policyId instanceof PolicyId) {
            return (PolicyId)((Object)policyId);
        }
        return PolicyId.wrapInPolicyIdInvalidException(() -> new PolicyId(DefaultNamespacedEntityId.of((CharSequence)policyId)));
    }

    public static PolicyId of(PolicyId policyId) {
        return policyId;
    }

    public static PolicyId of(String namespace, String policyName) {
        return PolicyId.wrapInPolicyIdInvalidException(() -> new PolicyId(DefaultNamespacedEntityId.of((String)namespace, (String)policyName)));
    }

    public static PolicyId inNamespaceWithRandomName(String namespace) {
        return PolicyId.of(namespace, UUID.randomUUID().toString());
    }

    private static <T> T wrapInPolicyIdInvalidException(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (NamespacedEntityIdInvalidException e) {
            throw (PolicyIdInvalidException)PolicyIdInvalidException.newBuilder(e.getEntityId().orElse(null)).cause(e).build();
        }
    }

    public static PolicyId dummy() {
        return DUMMY_ID;
    }

    public EntityType getEntityType() {
        return PolicyConstants.ENTITY_TYPE;
    }
}

